/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SizedIcon;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.EmptyIcon;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunConfigurationsComboBoxAction
extends ComboBoxAction
implements DumbAware {
    public static final Icon CHECKED_ICON = new SizedIcon(AllIcons.Actions.Checked, 16, 16);
    public static final Icon CHECKED_SELECTED_ICON = new SizedIcon(AllIcons.Actions.Checked_selected, 16, 16);
    public static final Icon EMPTY_ICON = EmptyIcon.ICON_16;

    public void actionPerformed(AnActionEvent e) {
        if (e.getPresentation().getClientProperty("customComponent") == null) {
            IdeFrameImpl frame;
            Project project = e.getProject();
            IdeFrameImpl ideFrameImpl = frame = project != null ? WindowManagerEx.getInstanceEx().getFrame(project) : null;
            if (frame != null) {
                e.getPresentation().putClientProperty("customComponent", (Object)frame.getComponent());
            }
        }
        super.actionPerformed(e);
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace())) {
            presentation.setDescription(ExecutionBundle.message((String)"choose.run.configuration.action.description", (Object[])new Object[0]));
        }
        try {
            if (project == null || project.isDisposed() || !project.isInitialized()) {
                RunConfigurationsComboBoxAction.updatePresentation(null, null, null, presentation);
                presentation.setEnabled(false);
            } else {
                RunConfigurationsComboBoxAction.updatePresentation(ExecutionTargetManager.getActiveTarget((Project)project), RunManagerEx.getInstanceEx(project).getSelectedConfiguration(), project, presentation);
                presentation.setEnabled(true);
            }
        }
        catch (IndexNotReadyException e1) {
            presentation.setEnabled(false);
        }
    }

    private static void updatePresentation(@Nullable ExecutionTarget target, @Nullable RunnerAndConfigurationSettings settings, @Nullable Project project, @NotNull Presentation presentation) {
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/execution/actions/RunConfigurationsComboBoxAction", "updatePresentation"));
        }
        if (project != null && target != null && settings != null) {
            String name = settings.getName();
            if (target != DefaultExecutionTarget.INSTANCE) {
                name = name + " | " + target.getDisplayName();
            } else if (!settings.canRunOn(target)) {
                name = name + " | Nothing to run on";
            }
            presentation.setText(name, false);
            RunConfigurationsComboBoxAction.setConfigurationIcon(presentation, settings, project);
        } else {
            presentation.setText("");
            presentation.setIcon(null);
        }
    }

    private static void setConfigurationIcon(Presentation presentation, final RunnerAndConfigurationSettings settings, Project project) {
        try {
            Icon icon = RunManagerEx.getInstanceEx(project).getConfigurationIcon(settings);
            ExecutionManagerImpl executionManager = ExecutionManagerImpl.getInstance(project);
            List<RunContentDescriptor> runningDescriptors = executionManager.getRunningDescriptors(new Condition<RunnerAndConfigurationSettings>(){

                public boolean value(RunnerAndConfigurationSettings s) {
                    return s == settings;
                }
            });
            if (runningDescriptors.size() == 1) {
                icon = ExecutionUtil.getLiveIndicator((Icon)icon);
            }
            if (runningDescriptors.size() > 1) {
                icon = IconUtil.addText((Icon)icon, (String)String.valueOf(runningDescriptors.size()));
            }
            presentation.setIcon(icon);
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
    }

    protected boolean shouldShowDisabledActions() {
        return true;
    }

    public JComponent createCustomComponent(Presentation presentation) {
        ComboBoxAction.ComboBoxButton button = this.createComboBoxButton(presentation);
        button.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        NonOpaquePanel panel = new NonOpaquePanel((LayoutManager)new BorderLayout());
        panel.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)0, (int)0, (int)2));
        panel.add((Component)button);
        return panel;
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(JComponent button) {
        DefaultActionGroup allActionsGroup = new DefaultActionGroup();
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)button));
        if (project != null) {
            RunManagerEx runManager = RunManagerEx.getInstanceEx(project);
            allActionsGroup.add(ActionManager.getInstance().getAction("editRunConfigurations"));
            allActionsGroup.add((AnAction)new SaveTemporaryAction());
            allActionsGroup.addSeparator();
            RunnerAndConfigurationSettings selected = RunManager.getInstance((Project)project).getSelectedConfiguration();
            if (selected != null) {
                ExecutionTarget activeTarget = ExecutionTargetManager.getActiveTarget((Project)project);
                for (ExecutionTarget eachTarget : ExecutionTargetManager.getTargetsToChooseFor((Project)project, (RunnerAndConfigurationSettings)selected)) {
                    allActionsGroup.add((AnAction)new SelectTargetAction(project, eachTarget, eachTarget.equals((Object)activeTarget)));
                }
                allActionsGroup.addSeparator();
            }
            ConfigurationType[] types = runManager.getConfigurationFactories();
            for (ConfigurationType type : types) {
                DefaultActionGroup actionGroup = new DefaultActionGroup();
                Map<String, List<RunnerAndConfigurationSettings>> structure = runManager.getStructure(type);
                for (Map.Entry<String, List<RunnerAndConfigurationSettings>> entry : structure.entrySet()) {
                    DefaultActionGroup group = entry.getKey() != null ? new DefaultActionGroup(entry.getKey(), true) : actionGroup;
                    group.getTemplatePresentation().setIcon(AllIcons.Nodes.Folder);
                    for (RunnerAndConfigurationSettings settings : entry.getValue()) {
                        group.add((AnAction)new SelectConfigAction(settings, project));
                    }
                    if (group == actionGroup) continue;
                    actionGroup.add((AnAction)group);
                }
                allActionsGroup.add((AnAction)actionGroup);
                allActionsGroup.addSeparator();
            }
        }
        DefaultActionGroup defaultActionGroup = allActionsGroup;
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/actions/RunConfigurationsComboBoxAction", "createPopupActionGroup"));
        }
        return defaultActionGroup;
    }

    private static class SelectConfigAction
    extends DumbAwareAction {
        private final RunnerAndConfigurationSettings myConfiguration;
        private final Project myProject;

        public SelectConfigAction(RunnerAndConfigurationSettings configuration, Project project) {
            this.myConfiguration = configuration;
            this.myProject = project;
            String name = configuration.getName();
            if (name == null || name.length() == 0) {
                name = " ";
            }
            Presentation presentation = this.getTemplatePresentation();
            presentation.setText(name, false);
            ConfigurationType type = configuration.getType();
            if (type != null) {
                presentation.setDescription("Select " + type.getConfigurationTypeDescription() + " '" + name + "'");
            }
            this.updateIcon(presentation);
        }

        private void updateIcon(Presentation presentation) {
            RunConfigurationsComboBoxAction.setConfigurationIcon(presentation, this.myConfiguration, this.myProject);
        }

        public void actionPerformed(AnActionEvent e) {
            RunManager.getInstance((Project)this.myProject).setSelectedConfiguration(this.myConfiguration);
            RunConfigurationsComboBoxAction.updatePresentation(ExecutionTargetManager.getActiveTarget((Project)this.myProject), this.myConfiguration, this.myProject, e.getPresentation());
        }

        public void update(AnActionEvent e) {
            super.update(e);
            this.updateIcon(e.getPresentation());
        }
    }

    private static class SelectTargetAction
    extends AnAction {
        private final Project myProject;
        private final ExecutionTarget myTarget;

        public SelectTargetAction(Project project, ExecutionTarget target, boolean selected) {
            this.myProject = project;
            this.myTarget = target;
            String name = target.getDisplayName();
            Presentation presentation = this.getTemplatePresentation();
            presentation.setText(name, false);
            presentation.setDescription("Select " + name);
            presentation.setIcon(selected ? CHECKED_ICON : EMPTY_ICON);
            presentation.setSelectedIcon(selected ? CHECKED_SELECTED_ICON : EMPTY_ICON);
        }

        public void actionPerformed(AnActionEvent e) {
            ExecutionTargetManager.setActiveTarget((Project)this.myProject, (ExecutionTarget)this.myTarget);
            RunConfigurationsComboBoxAction.updatePresentation(ExecutionTargetManager.getActiveTarget((Project)this.myProject), RunManagerEx.getInstanceEx(this.myProject).getSelectedConfiguration(), this.myProject, e.getPresentation());
        }
    }

    private static class SaveTemporaryAction
    extends DumbAwareAction {
        public SaveTemporaryAction() {
            Presentation presentation = this.getTemplatePresentation();
            presentation.setIcon(AllIcons.Actions.Menu_saveall);
        }

        public void actionPerformed(AnActionEvent e) {
            RunnerAndConfigurationSettings settings;
            Project project = (Project)e.getData(CommonDataKeys.PROJECT);
            if (project != null && (settings = SaveTemporaryAction.chooseTempSettings(project)) != null) {
                RunManager runManager = RunManager.getInstance((Project)project);
                runManager.makeStable(settings);
            }
        }

        public void update(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            Project project = (Project)e.getData(CommonDataKeys.PROJECT);
            if (project == null) {
                SaveTemporaryAction.disable(presentation);
                return;
            }
            RunnerAndConfigurationSettings settings = SaveTemporaryAction.chooseTempSettings(project);
            if (settings == null) {
                SaveTemporaryAction.disable(presentation);
            } else {
                presentation.setText(ExecutionBundle.message((String)"save.temporary.run.configuration.action.name", (Object[])new Object[]{settings.getName()}));
                presentation.setDescription(presentation.getText());
                presentation.setVisible(true);
                presentation.setEnabled(true);
            }
        }

        private static void disable(Presentation presentation) {
            presentation.setEnabled(false);
            presentation.setVisible(false);
        }

        @Nullable
        private static RunnerAndConfigurationSettings chooseTempSettings(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/actions/RunConfigurationsComboBoxAction$SaveTemporaryAction", "chooseTempSettings"));
            }
            RunnerAndConfigurationSettings selectedConfiguration = RunManager.getInstance((Project)project).getSelectedConfiguration();
            if (selectedConfiguration != null && selectedConfiguration.isTemporary()) {
                return selectedConfiguration;
            }
            Iterator iterator = RunManager.getInstance((Project)project).getTempConfigurationsList().iterator();
            return iterator.hasNext() ? (RunnerAndConfigurationSettings)iterator.next() : null;
        }
    }
}

