/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.ui.statistics;

import com.intellij.execution.testframework.sm.SMTestsRunnerBundle;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.TestsPresentationUtil;
import com.intellij.execution.testframework.sm.runner.ui.statistics.BaseColumn;
import com.intellij.execution.testframework.sm.runner.ui.statistics.ColoredRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import java.util.Comparator;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.Nullable;

public class ColumnDuration
extends BaseColumn
implements Comparator<SMTestProxy> {
    public ColumnDuration() {
        super(SMTestsRunnerBundle.message("sm.test.runner.ui.tabs.statistics.columns.duration.title", new Object[0]));
    }

    public String valueOf(SMTestProxy testProxy) {
        return TestsPresentationUtil.getDurationPresentation(testProxy);
    }

    @Nullable
    public Comparator<SMTestProxy> getComparator() {
        return this;
    }

    @Override
    public int compare(SMTestProxy proxy1, SMTestProxy proxy2) {
        Long duration1 = proxy1.getDuration();
        Long duration2 = proxy2.getDuration();
        if (duration1 == null) {
            return duration2 == null ? 0 : -1;
        }
        if (duration2 == null) {
            return 1;
        }
        return duration1.compareTo(duration2);
    }

    public TableCellRenderer getRenderer(SMTestProxy proxy) {
        return new DurationCellRenderer();
    }

    public static class DurationCellRenderer
    extends ColoredTableCellRenderer
    implements ColoredRenderer {
        @Override
        public void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
            assert (value != null);
            this.append(value.toString(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }
}

