/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.ui;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.HyperLink;
import com.intellij.execution.testframework.Printable;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.ui.TestResultsPanel;
import com.intellij.execution.testframework.ui.TestsConsoleBuilderImpl;
import com.intellij.execution.testframework.ui.TestsOutputConsolePrinter;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ObservableConsoleView;
import com.intellij.ide.HelpIdProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.util.Disposer;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseTestsOutputConsoleView
implements ConsoleView,
ObservableConsoleView,
HelpIdProvider {
    private ConsoleView myConsole;
    private TestsOutputConsolePrinter myPrinter;
    protected TestConsoleProperties myProperties;
    protected TestResultsPanel myTestResultsPanel;

    public BaseTestsOutputConsoleView(TestConsoleProperties properties, AbstractTestProxy unboundOutputRoot) {
        this.myProperties = properties;
        this.myConsole = new TestsConsoleBuilderImpl(properties.getProject(), this.myProperties.getScope(), !properties.isEditable(), properties.isUsePredefinedMessageFilter()).getConsole();
        this.myPrinter = new TestsOutputConsolePrinter(this, properties, unboundOutputRoot);
        this.myProperties.setConsole(this);
        Disposer.register((Disposable)this, (Disposable)this.myProperties);
        Disposer.register((Disposable)this, (Disposable)this.myConsole);
    }

    public void initUI() {
        this.myTestResultsPanel = this.createTestResultsPanel();
        this.myTestResultsPanel.initUI();
        Disposer.register((Disposable)this, (Disposable)this.myTestResultsPanel);
    }

    protected abstract TestResultsPanel createTestResultsPanel();

    public void attachToProcess(ProcessHandler processHandler2) {
        this.myConsole.attachToProcess(processHandler2);
    }

    public void print(final @NotNull String s, final @NotNull ConsoleViewContentType contentType) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/execution/testframework/ui/BaseTestsOutputConsoleView", "print"));
        }
        if (contentType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentType", "com/intellij/execution/testframework/ui/BaseTestsOutputConsoleView", "print"));
        }
        this.printNew(new Printable(){

            @Override
            public void printOn(Printer printer) {
                printer.print(s, contentType);
            }
        });
    }

    public void allowHeavyFilters() {
    }

    public void clear() {
        this.myConsole.clear();
    }

    public void scrollTo(int offset) {
        this.myConsole.scrollTo(offset);
    }

    public void setOutputPaused(boolean value) {
        if (this.myPrinter != null) {
            this.myPrinter.pause(value);
        }
    }

    public boolean isOutputPaused() {
        return this.myPrinter == null ? true : this.myPrinter.isPaused();
    }

    public boolean hasDeferredOutput() {
        return this.myConsole.hasDeferredOutput();
    }

    public void performWhenNoDeferredOutput(Runnable runnable2) {
        this.myConsole.performWhenNoDeferredOutput(runnable2);
    }

    public void setHelpId(String helpId) {
        this.myConsole.setHelpId(helpId);
    }

    public void addMessageFilter(Filter filter) {
        this.myConsole.addMessageFilter(filter);
    }

    public void printHyperlink(String hyperlinkText, HyperlinkInfo info) {
        this.printNew(new HyperLink(hyperlinkText, info));
    }

    public int getContentSize() {
        return this.myConsole.getContentSize();
    }

    public boolean canPause() {
        return this.myPrinter != null && this.myPrinter.canPause() && this.myConsole.canPause();
    }

    public JComponent getComponent() {
        return this.myTestResultsPanel;
    }

    public JComponent getPreferredFocusableComponent() {
        return this.myTestResultsPanel;
    }

    public void dispose() {
        this.myPrinter = null;
        this.myProperties = null;
        this.myConsole = null;
    }

    public void addChangeListener(@NotNull ObservableConsoleView.ChangeListener listener, @NotNull Disposable parent) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/execution/testframework/ui/BaseTestsOutputConsoleView", "addChangeListener"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/execution/testframework/ui/BaseTestsOutputConsoleView", "addChangeListener"));
        }
        if (!(this.myConsole instanceof ObservableConsoleView)) {
            throw new UnsupportedOperationException(this.myConsole.getClass().getName());
        }
        ((ObservableConsoleView)this.myConsole).addChangeListener(listener, parent);
    }

    @NotNull
    public AnAction[] createConsoleActions() {
        if (AnAction.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/ui/BaseTestsOutputConsoleView", "createConsoleActions"));
        }
        return AnAction.EMPTY_ARRAY;
    }

    @NotNull
    public ConsoleView getConsole() {
        ConsoleView consoleView = this.myConsole;
        if (consoleView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/ui/BaseTestsOutputConsoleView", "getConsole"));
        }
        return consoleView;
    }

    public TestsOutputConsolePrinter getPrinter() {
        return this.myPrinter;
    }

    private void printNew(Printable printable) {
        if (this.myPrinter != null) {
            this.myPrinter.onNewAvailable(printable);
        }
    }

    public TestConsoleProperties getProperties() {
        return this.myProperties;
    }

    @Nullable
    public String getHelpId() {
        return "reference.runToolWindow.testResultsTab";
    }
}

