/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core.tree;

import com.intellij.history.core.StreamUtil;
import com.intellij.history.core.revisions.Difference;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.utils.LocalHistoryLog;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DirectoryEntry
extends Entry {
    private final ArrayList<Entry> myChildren;

    public DirectoryEntry(String name) {
        super(name);
        this.myChildren = new ArrayList(3);
    }

    public DirectoryEntry(DataInput in, boolean dummy) throws IOException {
        super(in);
        int count = DataInputOutputUtil.readINT((DataInput)in);
        this.myChildren = new ArrayList(count);
        while (count-- > 0) {
            this.unsafeAddChild(StreamUtil.readEntry(in));
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        DataInputOutputUtil.writeINT((DataOutput)out, (int)this.myChildren.size());
        for (Entry child : this.myChildren) {
            StreamUtil.writeEntry(out, child);
        }
    }

    @Override
    public long getTimestamp() {
        return -1L;
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public void addChild(Entry child) {
        if (!this.checkDoesNotExist(child, child.getName())) {
            return;
        }
        this.unsafeAddChild(child);
    }

    @Override
    public void addChildren(Collection<Entry> children2) {
        this.myChildren.ensureCapacity(this.myChildren.size() + children2.size());
        for (Entry each : children2) {
            this.unsafeAddChild(each);
        }
    }

    private void unsafeAddChild(Entry child) {
        this.myChildren.add(child);
        child.setParent(this);
    }

    protected boolean checkDoesNotExist(Entry e, String name) {
        Entry found = this.findChild(name);
        if (found == null) {
            return true;
        }
        if (found == e) {
            return false;
        }
        this.removeChild(found);
        LocalHistoryLog.LOG.warn(String.format("entry '%s' already exists in '%s'", name, this.getPath()));
        return true;
    }

    @Override
    public void removeChild(Entry child) {
        this.myChildren.remove(child);
        child.setParent(null);
    }

    @Override
    public List<Entry> getChildren() {
        return this.myChildren;
    }

    @Override
    public boolean hasUnavailableContent(List<Entry> entriesWithUnavailableContent) {
        for (Entry e : this.myChildren) {
            e.hasUnavailableContent(entriesWithUnavailableContent);
        }
        return !entriesWithUnavailableContent.isEmpty();
    }

    @Override
    @NotNull
    public DirectoryEntry copy() {
        DirectoryEntry result2 = this.copyEntry();
        result2.myChildren.ensureCapacity(this.myChildren.size());
        for (Entry child : this.myChildren) {
            result2.unsafeAddChild(child.copy());
        }
        DirectoryEntry directoryEntry = result2;
        if (directoryEntry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/history/core/tree/DirectoryEntry", "copy"));
        }
        return directoryEntry;
    }

    protected DirectoryEntry copyEntry() {
        return new DirectoryEntry(this.myName);
    }

    @Override
    public void collectDifferencesWith(Entry right, List<Difference> result2) {
        DirectoryEntry e = (DirectoryEntry)right;
        if (!this.getPath().equals(e.getPath())) {
            result2.add(new Difference(false, this, e));
        }
        this.addCreatedChildrenDifferences(e, result2);
        this.addDeletedChildrenDifferences(e, result2);
        this.addModifiedChildrenDifferences(e, result2);
    }

    private void addCreatedChildrenDifferences(DirectoryEntry e, List<Difference> result2) {
        for (Entry child : e.myChildren) {
            if (this.findDirectChild(child.getName(), child.isDirectory()) != null) continue;
            child.collectCreatedDifferences(result2);
        }
    }

    private void addDeletedChildrenDifferences(DirectoryEntry e, List<Difference> result2) {
        for (Entry child : this.myChildren) {
            if (e.findDirectChild(child.getName(), child.isDirectory()) != null) continue;
            child.collectDeletedDifferences(result2);
        }
    }

    private void addModifiedChildrenDifferences(DirectoryEntry e, List<Difference> result2) {
        for (Entry myChild : this.myChildren) {
            Entry itsChild = e.findDirectChild(myChild.getName(), myChild.isDirectory());
            if (itsChild == null) continue;
            myChild.collectDifferencesWith(itsChild, result2);
        }
    }

    Entry findDirectChild(String name, boolean isDirectory) {
        for (Entry child : this.getChildren()) {
            if (child.isDirectory() != isDirectory || !child.nameEquals(name)) continue;
            return child;
        }
        return null;
    }

    @Override
    protected void collectCreatedDifferences(List<Difference> result2) {
        result2.add(new Difference(false, null, this));
        for (Entry child : this.myChildren) {
            child.collectCreatedDifferences(result2);
        }
    }

    @Override
    protected void collectDeletedDifferences(List<Difference> result2) {
        result2.add(new Difference(false, this, null));
        for (Entry child : this.myChildren) {
            child.collectDeletedDifferences(result2);
        }
    }
}

