/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeView;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.actions.AttributesDefaults;
import com.intellij.ide.fileTemplates.actions.CreateFromTemplateActionBase;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.util.PsiUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class CreatePackageInfoAction
extends CreateFromTemplateActionBase
implements DumbAware {
    public CreatePackageInfoAction() {
        super(IdeBundle.message((String)"action.create.new.package-info.title", (Object[])new Object[0]), IdeBundle.message((String)"action.create.new.package-info.description", (Object[])new Object[0]), AllIcons.FileTypes.Java);
    }

    @Override
    @Nullable
    protected PsiDirectory getTargetDirectory(DataContext dataContext, IdeView view) {
        PsiDirectory[] directories;
        for (PsiDirectory directory : directories = view.getDirectories()) {
            PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(directory);
            if (aPackage == null) continue;
            if (directory.findFile("package-info.java") != null) {
                Messages.showErrorDialog((Project)((Project)CommonDataKeys.PROJECT.getData(dataContext)), (String)IdeBundle.message((String)"error.package.already.contains.package-info", (Object[])new Object[]{aPackage.getQualifiedName()}), (String)IdeBundle.message((String)"title.cannot.create.file", (Object[])new Object[0]));
                return null;
            }
            if (directory.findFile("package.html") == null || Messages.showOkCancelDialog((Project)((Project)CommonDataKeys.PROJECT.getData(dataContext)), (String)IdeBundle.message((String)"error.package.already.contains.package.html", (Object[])new Object[]{aPackage.getQualifiedName()}), (String)IdeBundle.message((String)"error.package.html.found.title", (Object[])new Object[0]), (String)IdeBundle.message((String)"button.create", (Object[])new Object[0]), (String)CommonBundle.message((String)"button.cancel", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0) continue;
            return null;
        }
        return super.getTargetDirectory(dataContext, view);
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabledAndVisible(CreatePackageInfoAction.isAvailable(e.getDataContext()));
    }

    private static boolean isAvailable(DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (project == null || view == null) {
            return false;
        }
        PsiDirectory[] directories = view.getDirectories();
        if (directories.length == 0) {
            return false;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        JavaDirectoryService directoryService = JavaDirectoryService.getInstance();
        PsiNameHelper nameHelper = PsiNameHelper.getInstance((Project)project);
        for (PsiDirectory directory : directories) {
            String qualifiedName;
            PsiPackage aPackage;
            if (!projectFileIndex.isUnderSourceRootOfType(directory.getVirtualFile(), JavaModuleSourceRootTypes.SOURCES) || !PsiUtil.isLanguageLevel5OrHigher((PsiElement)directory) || (aPackage = directoryService.getPackage(directory)) == null || !StringUtil.isEmpty((String)(qualifiedName = aPackage.getQualifiedName())) && !nameHelper.isQualifiedName(qualifiedName)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public AttributesDefaults getAttributesDefaults(DataContext dataContext) {
        return new AttributesDefaults("package-info").withFixedName(true);
    }

    @Override
    protected FileTemplate getTemplate(Project project, PsiDirectory dir) {
        return FileTemplateManager.getInstance(project).getInternalTemplate("package-info");
    }
}

