/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInspection.InspectionProfile;
import com.intellij.ide.actions.QuickSwitchSchemeAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.profile.Profile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuickChangeInspectionProfileAction
extends QuickSwitchSchemeAction {
    protected void fillActions(Project project, @NotNull DefaultActionGroup group, @NotNull DataContext dataContext) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/ide/actions/QuickChangeInspectionProfileAction", "fillActions"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ide/actions/QuickChangeInspectionProfileAction", "fillActions"));
        }
        InspectionProjectProfileManager projectProfileManager = InspectionProjectProfileManager.getInstance(project);
        InspectionProfile current = projectProfileManager.getInspectionProfile();
        for (Profile profile : projectProfileManager.getProfiles()) {
            QuickChangeInspectionProfileAction.addScheme(group, projectProfileManager, (Profile)current, profile);
        }
    }

    private static void addScheme(DefaultActionGroup group, final InspectionProjectProfileManager projectProfileManager, Profile current, final Profile scheme) {
        group.add((AnAction)new DumbAwareAction(scheme.getName(), "", scheme == current ? ourCurrentAction : ourNotCurrentAction){

            public void actionPerformed(@Nullable AnActionEvent e) {
                projectProfileManager.setProjectProfile(scheme.getName());
            }
        });
    }

    protected boolean isEnabled() {
        return true;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/QuickChangeInspectionProfileAction", "update"));
        }
        Project project = QuickChangeInspectionProfileAction.getEventProject((AnActionEvent)e);
        e.getPresentation().setEnabledAndVisible(project != null && InspectionProjectProfileManager.getInstance(project).getProfiles().size() > 1);
    }
}

