/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;

public abstract class UndoRedoAction
extends DumbAwareAction {
    public UndoRedoAction() {
        this.setEnabledInModalContext(true);
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        FileEditor editor = (FileEditor)PlatformDataKeys.FILE_EDITOR.getData(dataContext);
        UndoManager undoManager = UndoRedoAction.getUndoManager(editor, dataContext);
        this.perform(editor, undoManager);
    }

    public void update(AnActionEvent event) {
        Boolean isModalContext;
        Presentation presentation = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        FileEditor editor = (FileEditor)PlatformDataKeys.FILE_EDITOR.getData(dataContext);
        if (editor == null && (isModalContext = (Boolean)PlatformDataKeys.IS_MODAL_CONTEXT.getData(dataContext)) != null && isModalContext.booleanValue()) {
            presentation.setEnabled(false);
            return;
        }
        UndoManager undoManager = UndoRedoAction.getUndoManager(editor, dataContext);
        if (undoManager == null) {
            presentation.setEnabled(false);
            return;
        }
        presentation.setEnabled(this.isAvailable(editor, undoManager));
        Pair<String, String> pair = this.getActionNameAndDescription(editor, undoManager);
        presentation.setText((String)pair.first);
        presentation.setDescription((String)pair.second);
    }

    private static UndoManager getUndoManager(FileEditor editor, DataContext dataContext) {
        Project project = UndoRedoAction.getProject(editor, dataContext);
        return project != null ? UndoManager.getInstance((Project)project) : UndoManager.getGlobalInstance();
    }

    private static Project getProject(FileEditor editor, DataContext dataContext) {
        Project project = editor instanceof TextEditor ? ((TextEditor)editor).getEditor().getProject() : (Project)CommonDataKeys.PROJECT.getData(dataContext);
        return project;
    }

    protected abstract void perform(FileEditor var1, UndoManager var2);

    protected abstract boolean isAvailable(FileEditor var1, UndoManager var2);

    protected abstract Pair<String, String> getActionNameAndDescription(FileEditor var1, UndoManager var2);
}

