/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.diff;

import com.intellij.ide.diff.DiffElement;
import com.intellij.ide.presentation.VirtualFilePresentation;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TransferableFileEditorState;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.util.PlatformIcons;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualFileDiffElement
extends DiffElement<VirtualFile> {
    private final VirtualFile myFile;
    private FileEditor myFileEditor;
    private FileEditorProvider myEditorProvider;

    public VirtualFileDiffElement(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/diff/VirtualFileDiffElement", "<init>"));
        }
        this.myFile = file2;
    }

    public String getPath() {
        return this.myFile.getPresentableUrl();
    }

    @NotNull
    public String getName() {
        String string = this.myFile.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/diff/VirtualFileDiffElement", "getName"));
        }
        return string;
    }

    public String getPresentablePath() {
        return this.getPath();
    }

    public long getSize() {
        return this.myFile.getLength();
    }

    public long getTimeStamp() {
        return this.myFile.getTimeStamp();
    }

    public boolean isContainer() {
        return this.myFile.isDirectory();
    }

    @Nullable
    public OpenFileDescriptor getOpenFileDescriptor(@Nullable Project project) {
        if (project == null || project.isDefault()) {
            return null;
        }
        return new OpenFileDescriptor(project, this.myFile);
    }

    public VirtualFileDiffElement[] getChildren() {
        if (this.myFile.is(VFileProperty.SYMLINK)) {
            return new VirtualFileDiffElement[0];
        }
        VirtualFile[] files = this.myFile.getChildren();
        ArrayList<VirtualFileDiffElement> elements = new ArrayList<VirtualFileDiffElement>();
        for (VirtualFile file2 : files) {
            if (FileTypeManager.getInstance().isFileIgnored(file2) || !file2.isValid()) continue;
            elements.add(new VirtualFileDiffElement(file2));
        }
        return elements.toArray(new VirtualFileDiffElement[elements.size()]);
    }

    public byte[] getContent() throws IOException {
        return this.myFile.contentsToByteArray();
    }

    public VirtualFile getValue() {
        return this.myFile;
    }

    public Icon getIcon() {
        return this.isContainer() ? PlatformIcons.FOLDER_ICON : VirtualFilePresentation.getIcon((VirtualFile)this.myFile);
    }

    public Callable<DiffElement<VirtualFile>> getElementChooser(final Project project) {
        return new Callable<DiffElement<VirtualFile>>(){

            @Override
            @Nullable
            public DiffElement<VirtualFile> call() throws Exception {
                FileChooserDescriptor descriptor = VirtualFileDiffElement.this.getChooserDescriptor();
                VirtualFile[] result2 = FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)project, (VirtualFile)VirtualFileDiffElement.this.getValue());
                return result2.length == 1 ? VirtualFileDiffElement.this.createElement(result2[0]) : null;
            }
        };
    }

    @Nullable
    protected VirtualFileDiffElement createElement(VirtualFile file2) {
        return new VirtualFileDiffElement(file2);
    }

    protected FileChooserDescriptor getChooserDescriptor() {
        return new FileChooserDescriptor(false, true, false, false, false, false);
    }

    protected JComponent getFromProviders(Project project, DiffElement target) {
        FileEditorProvider[] providers;
        if (project == null) {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        if ((providers = FileEditorProviderManager.getInstance().getProviders(project, this.getValue())).length > 0) {
            this.myFileEditor = providers[0].createEditor(project, this.getValue());
            this.myEditorProvider = providers[0];
            VirtualFileDiffElement.setCustomState(this.myFileEditor);
            return this.myFileEditor.getComponent();
        }
        return null;
    }

    private static void setCustomState(FileEditor editor) {
        FileEditorState state = editor.getState(FileEditorStateLevel.FULL);
        if (state instanceof TransferableFileEditorState) {
            TransferableFileEditorState editorState = (TransferableFileEditorState)state;
            String id = editorState.getEditorId();
            HashMap<String, String> options = new HashMap<String, String>();
            PropertiesComponent properties = PropertiesComponent.getInstance();
            for (String key : editorState.getTransferableOptions().keySet()) {
                String value = properties.getValue(VirtualFileDiffElement.getKey(id, key));
                if (value == null) continue;
                options.put(key, value);
            }
            editorState.setTransferableOptions(options);
            editor.setState((FileEditorState)editorState);
        }
    }

    private static void saveCustomState(FileEditor editor) {
        FileEditorState state = editor.getState(FileEditorStateLevel.FULL);
        if (state instanceof TransferableFileEditorState) {
            TransferableFileEditorState editorState = (TransferableFileEditorState)state;
            String id = editorState.getEditorId();
            PropertiesComponent properties = PropertiesComponent.getInstance();
            Map options = editorState.getTransferableOptions();
            for (String key : options.keySet()) {
                properties.setValue(VirtualFileDiffElement.getKey(id, key), (String)options.get(key));
            }
        }
    }

    private static String getKey(String editorId, String key) {
        return "dir.diff.editor.options." + editorId + "." + key;
    }

    protected DiffRequest createRequestForBinaries(Project project, @NotNull VirtualFile src, @NotNull VirtualFile trg) {
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/intellij/ide/diff/VirtualFileDiffElement", "createRequestForBinaries"));
        }
        if (trg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trg", "com/intellij/ide/diff/VirtualFileDiffElement", "createRequestForBinaries"));
        }
        if (project == null) {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        if (FileEditorProviderManager.getInstance().getProviders(project, src).length > 0 && FileEditorProviderManager.getInstance().getProviders(project, trg).length > 0) {
            return super.createRequestForBinaries(project, src, trg);
        }
        return null;
    }

    public void disposeViewComponent() {
        super.disposeViewComponent();
        if (this.myFileEditor != null && this.myEditorProvider != null) {
            VirtualFileDiffElement.saveCustomState(this.myFileEditor);
            this.myEditorProvider.disposeEditor(this.myFileEditor);
            this.myFileEditor = null;
            this.myEditorProvider = null;
        }
    }

    public DataProvider getDataProvider(final Project project) {
        return new DataProvider(){

            public Object getData(@NonNls String dataId) {
                if (CommonDataKeys.PROJECT.is(dataId)) {
                    return project;
                }
                if (PlatformDataKeys.FILE_EDITOR.is(dataId)) {
                    return VirtualFileDiffElement.this.myFileEditor;
                }
                return null;
            }
        };
    }

    public boolean isOperationsEnabled() {
        return this.myFile.getFileSystem() instanceof LocalFileSystem;
    }

    public VirtualFileDiffElement copyTo(DiffElement<VirtualFile> container, String relativePath) {
        try {
            File src = new File(this.myFile.getPath());
            File trg = new File(((VirtualFile)container.getValue()).getPath() + relativePath + src.getName());
            FileUtil.copy((File)src, (File)trg);
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(trg);
            if (virtualFile != null) {
                return new VirtualFileDiffElement(virtualFile);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public boolean delete() {
        try {
            this.myFile.delete((Object)this);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public void refresh(boolean userInitiated) {
        VirtualFileDiffElement.refreshFile(userInitiated, this.myFile);
    }

    public static void refreshFile(boolean userInitiated, VirtualFile virtualFile) {
        if (userInitiated) {
            final ArrayList<Document> docsToSave = new ArrayList<Document>();
            final FileDocumentManager manager = FileDocumentManager.getInstance();
            for (Document document : manager.getUnsavedDocuments()) {
                VirtualFile file2 = manager.getFile(document);
                if (file2 == null || !VfsUtilCore.isAncestor((VirtualFile)virtualFile, (VirtualFile)file2, (boolean)false)) continue;
                docsToSave.add(document);
            }
            if (!docsToSave.isEmpty()) {
                new WriteAction(){

                    protected void run(@NotNull Result result2) throws Throwable {
                        if (result2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/ide/diff/VirtualFileDiffElement$3", "run"));
                        }
                        for (Document document : docsToSave) {
                            manager.saveDocument(document);
                        }
                    }
                }.execute();
            }
            ModalityState modalityState = ProgressManager.getInstance().getProgressIndicator().getModalityState();
            VfsUtil.markDirty((boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{virtualFile});
            RefreshQueue.getInstance().refresh(false, true, null, modalityState, new VirtualFile[]{virtualFile});
        }
    }
}

