/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy.call;

import com.intellij.ide.hierarchy.CallHierarchyBrowserBase;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.hierarchy.JavaHierarchyUtil;
import com.intellij.ide.hierarchy.call.CallHierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.call.CalleeMethodsTreeStructure;
import com.intellij.ide.hierarchy.call.CallerMethodsTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.ui.PopupHandler;
import java.util.Comparator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

public class CallHierarchyBrowser
extends CallHierarchyBrowserBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.hierarchy.call.CallHierarchyBrowser");

    public CallHierarchyBrowser(@NotNull Project project, @NotNull PsiMethod method) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/hierarchy/call/CallHierarchyBrowser", "<init>"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/ide/hierarchy/call/CallHierarchyBrowser", "<init>"));
        }
        super(project, (PsiElement)method);
    }

    @Override
    protected void createTrees(@NotNull Map<String, JTree> type2TreeMap) {
        if (type2TreeMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type2TreeMap", "com/intellij/ide/hierarchy/call/CallHierarchyBrowser", "createTrees"));
        }
        ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction("CallHierarchyPopupMenu");
        JTree tree1 = this.createTree(false);
        PopupHandler.installPopupHandler((JComponent)tree1, (ActionGroup)group, (String)"CallHierarchyViewPopup", (ActionManager)ActionManager.getInstance());
        BaseOnThisMethodAction baseOnThisMethodAction = new BaseOnThisMethodAction();
        baseOnThisMethodAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("CallHierarchy").getShortcutSet(), tree1);
        type2TreeMap.put(CALLEE_TYPE, tree1);
        JTree tree2 = this.createTree(false);
        PopupHandler.installPopupHandler((JComponent)tree2, (ActionGroup)group, (String)"CallHierarchyViewPopup", (ActionManager)ActionManager.getInstance());
        baseOnThisMethodAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("CallHierarchy").getShortcutSet(), tree2);
        type2TreeMap.put(CALLER_TYPE, tree2);
    }

    @Override
    protected PsiElement getElementFromDescriptor(@NotNull HierarchyNodeDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/ide/hierarchy/call/CallHierarchyBrowser", "getElementFromDescriptor"));
        }
        if (descriptor instanceof CallHierarchyNodeDescriptor) {
            CallHierarchyNodeDescriptor nodeDescriptor = (CallHierarchyNodeDescriptor)descriptor;
            return nodeDescriptor.getEnclosingElement();
        }
        return null;
    }

    @Override
    protected PsiElement getOpenFileElementFromDescriptor(@NotNull HierarchyNodeDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/ide/hierarchy/call/CallHierarchyBrowser", "getOpenFileElementFromDescriptor"));
        }
        if (descriptor instanceof CallHierarchyNodeDescriptor) {
            CallHierarchyNodeDescriptor nodeDescriptor = (CallHierarchyNodeDescriptor)descriptor;
            return nodeDescriptor.getTargetElement();
        }
        return null;
    }

    @Override
    protected boolean isApplicableElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/hierarchy/call/CallHierarchyBrowser", "isApplicableElement"));
        }
        return element instanceof PsiMethod;
    }

    @Override
    protected HierarchyTreeStructure createHierarchyTreeStructure(@NotNull String typeName, @NotNull PsiElement psiElement) {
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "com/intellij/ide/hierarchy/call/CallHierarchyBrowser", "createHierarchyTreeStructure"));
        }
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/ide/hierarchy/call/CallHierarchyBrowser", "createHierarchyTreeStructure"));
        }
        if (CALLER_TYPE.equals(typeName)) {
            return new CallerMethodsTreeStructure(this.myProject, (PsiMethod)psiElement, this.getCurrentScopeType());
        }
        if (CALLEE_TYPE.equals(typeName)) {
            return new CalleeMethodsTreeStructure(this.myProject, (PsiMethod)psiElement, this.getCurrentScopeType());
        }
        LOG.error("unexpected type: " + typeName);
        return null;
    }

    @Override
    protected Comparator<NodeDescriptor> getComparator() {
        return JavaHierarchyUtil.getComparator(this.myProject);
    }

    public static final class BaseOnThisMethodAction
    extends CallHierarchyBrowserBase.BaseOnThisMethodAction {
    }
}

