/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.ide.util.gotoByName.ChooseByNameFilterConfiguration;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.FilteringGotoByModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Disposer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChooseByNameFilter<T> {
    private final ChooseByNamePopup myParentPopup;
    private final ActionToolbar myToolbar;
    private final ElementsChooser<T> myChooser;
    private final JPanel myChooserPanel;
    private JBPopup myPopup;
    private final Project myProject;

    public ChooseByNameFilter(@NotNull ChooseByNamePopup popup, @NotNull FilteringGotoByModel<T> model, @NotNull ChooseByNameFilterConfiguration<T> filterConfiguration, @NotNull Project project) {
        if (popup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popup", "com/intellij/ide/util/gotoByName/ChooseByNameFilter", "<init>"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/ide/util/gotoByName/ChooseByNameFilter", "<init>"));
        }
        if (filterConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterConfiguration", "com/intellij/ide/util/gotoByName/ChooseByNameFilter", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/util/gotoByName/ChooseByNameFilter", "<init>"));
        }
        this.myParentPopup = popup;
        DefaultActionGroup actionGroup = new DefaultActionGroup("go.to.file.filter", false);
        ToggleAction action = new ToggleAction("Filter", "Filter files by type", AllIcons.General.Filter){

            public boolean isSelected(AnActionEvent e) {
                return ChooseByNameFilter.this.myPopup != null;
            }

            public void setSelected(AnActionEvent e, boolean state) {
                if (state) {
                    ChooseByNameFilter.this.createPopup();
                } else {
                    ChooseByNameFilter.this.close();
                }
            }
        };
        actionGroup.add((AnAction)action);
        this.myToolbar = ActionManager.getInstance().createActionToolbar("gotfile.filter", (ActionGroup)actionGroup, true);
        this.myToolbar.setLayoutPolicy(0);
        this.myToolbar.updateActionsImmediately();
        this.myToolbar.getComponent().setFocusable(false);
        this.myToolbar.getComponent().setBorder(null);
        this.myProject = project;
        this.myChooser = this.createChooser(model, filterConfiguration);
        this.myChooserPanel = this.createChooserPanel();
        popup.setToolArea(this.myToolbar.getComponent());
    }

    private JPanel createChooserPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(this.myChooser);
        JPanel buttons = new JPanel();
        JButton all = new JButton("All");
        all.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseByNameFilter.this.myChooser.setAllElementsMarked(true);
            }
        });
        buttons.add(all);
        JButton none = new JButton("None");
        none.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseByNameFilter.this.myChooser.setAllElementsMarked(false);
            }
        });
        buttons.add(none);
        JButton invert = new JButton("Invert");
        invert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseByNameFilter.this.myChooser.invertSelection();
            }
        });
        buttons.add(invert);
        panel.add(buttons);
        return panel;
    }

    @NotNull
    protected ElementsChooser<T> createChooser(final @NotNull FilteringGotoByModel<T> model, final @NotNull ChooseByNameFilterConfiguration<T> filterConfiguration) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/ide/util/gotoByName/ChooseByNameFilter", "createChooser"));
        }
        if (filterConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterConfiguration", "com/intellij/ide/util/gotoByName/ChooseByNameFilter", "createChooser"));
        }
        ArrayList<T> elements = new ArrayList<T>(this.getAllFilterValues());
        final ElementsChooser chooser = new ElementsChooser<T>(elements, true){

            @Override
            protected String getItemText(@NotNull T value) {
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/ide/util/gotoByName/ChooseByNameFilter$5", "getItemText"));
                }
                return ChooseByNameFilter.this.textForFilterValue(value);
            }

            @Override
            protected Icon getItemIcon(@NotNull T value) {
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/ide/util/gotoByName/ChooseByNameFilter$5", "getItemIcon"));
                }
                return ChooseByNameFilter.this.iconForFilterValue(value);
            }
        };
        chooser.setFocusable(false);
        int count = chooser.getElementCount();
        for (int i = 0; i < count; ++i) {
            Object type = chooser.getElementAt(i);
            if (DumbService.getInstance((Project)this.myProject).isDumb() || filterConfiguration.isFileTypeVisible(type)) continue;
            chooser.setElementMarked(type, false);
        }
        this.updateModel(model, chooser, true);
        chooser.addElementsMarkListener(new ElementsChooser.ElementsMarkListener<T>(){

            @Override
            public void elementMarkChanged(T element, boolean isMarked) {
                filterConfiguration.setVisible(element, isMarked);
                ChooseByNameFilter.this.updateModel(model, chooser, false);
            }
        });
        ElementsChooser elementsChooser = chooser;
        if (elementsChooser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/ChooseByNameFilter", "createChooser"));
        }
        return elementsChooser;
    }

    protected abstract String textForFilterValue(@NotNull T var1);

    @Nullable
    protected abstract Icon iconForFilterValue(@NotNull T var1);

    @NotNull
    protected abstract Collection<T> getAllFilterValues();

    protected void updateModel(@NotNull FilteringGotoByModel<T> gotoFileModel, @NotNull ElementsChooser<T> chooser, boolean initial) {
        if (gotoFileModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gotoFileModel", "com/intellij/ide/util/gotoByName/ChooseByNameFilter", "updateModel"));
        }
        if (chooser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chooser", "com/intellij/ide/util/gotoByName/ChooseByNameFilter", "updateModel"));
        }
        List<T> markedElements = chooser.getMarkedElements();
        gotoFileModel.setFilterItems(markedElements);
        this.myParentPopup.rebuildList(initial);
    }

    private void createPopup() {
        if (this.myPopup != null) {
            return;
        }
        this.myPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)this.myChooserPanel, this.myChooser).setModalContext(false).setFocusable(false).setResizable(true).setCancelOnClickOutside(false).setMinSize(new Dimension(200, 200)).setDimensionServiceKey(this.myProject, "GotoFile_FileTypePopup", false).createPopup();
        this.myPopup.addListener((JBPopupListener)new JBPopupListener.Adapter(){

            public void onClosed(LightweightWindowEvent event) {
                ChooseByNameFilter.this.myPopup = null;
            }
        });
        this.myPopup.showUnderneathOf((Component)this.myToolbar.getComponent());
    }

    public void close() {
        if (this.myPopup != null) {
            Disposer.dispose((Disposable)this.myPopup);
        }
    }
}

