/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard.modes;

import com.intellij.ide.util.newProjectWizard.StepSequence;
import com.intellij.ide.util.newProjectWizard.modes.WizardMode;
import com.intellij.ide.util.projectWizard.AbstractModuleBuilder;
import com.intellij.ide.util.projectWizard.EmptyModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateFromScratchMode
extends WizardMode {
    @NonNls
    private final Map<String, ModuleBuilder> myBuildersMap = new HashMap<String, ModuleBuilder>();

    @Override
    @NotNull
    public String getDisplayName(WizardContext context) {
        String string = ProjectBundle.message((String)"project.new.wizard.from.scratch.title", (Object[])new Object[]{context.getPresentationName()});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/newProjectWizard/modes/CreateFromScratchMode", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getDescription(WizardContext context) {
        String string = ProjectBundle.message((String)"project.new.wizard.from.scratch.description", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName(), context.getPresentationName()});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/newProjectWizard/modes/CreateFromScratchMode", "getDescription"));
        }
        return string;
    }

    @Override
    @Nullable
    protected StepSequence createSteps(@NotNull WizardContext context, @NotNull ModulesProvider modulesProvider) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/ide/util/newProjectWizard/modes/CreateFromScratchMode", "createSteps"));
        }
        if (modulesProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulesProvider", "com/intellij/ide/util/newProjectWizard/modes/CreateFromScratchMode", "createSteps"));
        }
        List builders = ModuleBuilder.getAllBuilders();
        for (ModuleBuilder builder : builders) {
            this.myBuildersMap.put(builder.getBuilderId(), builder);
        }
        this.myBuildersMap.put(ModuleType.EMPTY.getId(), (ModuleBuilder)new EmptyModuleBuilder());
        StepSequence sequence = new StepSequence(new ModuleWizardStep[0]);
        for (ModuleBuilder builder : builders) {
            sequence.addStepsForBuilder((AbstractModuleBuilder)builder, context, modulesProvider);
        }
        return sequence;
    }

    @Override
    public boolean isAvailable(WizardContext context) {
        return true;
    }

    public ModuleBuilder getModuleBuilder() {
        return this.myBuildersMap.get(this.getSelectedType());
    }

    @Override
    public void onChosen(boolean enabled) {
    }

    @Override
    public String getShortName() {
        return "Create from Scratch";
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myBuildersMap.clear();
    }
}

