/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.vfs.VirtualFile;

public class DumpDirectoryInfoAction
extends AnAction {
    public static final Logger LOG = Logger.getInstance((String)("#" + DumpDirectoryInfoAction.class.getName()));

    public DumpDirectoryInfoAction() {
        super("Dump Directory Info");
    }

    public void actionPerformed(AnActionEvent e) {
        final Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        final DirectoryIndex index = DirectoryIndex.getInstance(project);
        if (project != null) {
            final VirtualFile root = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
            ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                @Override
                public void run() {
                    ContentIterator contentIterator = new ContentIterator(){

                        public boolean processFile(VirtualFile fileOrDir) {
                            LOG.info(fileOrDir.getPath());
                            LOG.info(index.getInfoForFile(fileOrDir).toString());
                            return true;
                        }
                    };
                    if (root != null) {
                        ProjectRootManager.getInstance((Project)project).getFileIndex().iterateContentUnderDirectory(root, contentIterator);
                    } else {
                        ProjectRootManager.getInstance((Project)project).getFileIndex().iterateContent(contentIterator);
                    }
                }
            }, "Dumping directory index", true, project);
        }
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabled(e.getData(CommonDataKeys.PROJECT) != null);
    }
}

