/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.codeInsight.intention.impl.config.IntentionActionMetaData;
import com.intellij.codeInsight.intention.impl.config.IntentionManagerSettings;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;

public class DumpIntentionsAction
extends AnAction
implements DumbAware {
    public DumpIntentionsAction() {
        super("Dump Intentions");
    }

    public void actionPerformed(AnActionEvent e) {
        VirtualFile file2 = FileChooser.chooseFile((FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFolderDescriptor(), (Project)((Project)e.getData(CommonDataKeys.PROJECT)), null);
        if (file2 != null) {
            List<IntentionActionMetaData> list = IntentionManagerSettings.getInstance().getMetaData();
            File root = VfsUtil.virtualToIoFile((VirtualFile)file2);
            Element el = new Element("root");
            HashMap<String, Element> categoryMap = new HashMap<String, Element>();
            for (IntentionActionMetaData metaData : list) {
                try {
                    Element metadataElement = new Element("intention");
                    metadataElement.setAttribute("family", metaData.getFamily());
                    metadataElement.setAttribute("description", metaData.getDescription().getText());
                    String key = StringUtil.join((String[])metaData.myCategory, (String)".");
                    Element element = DumpIntentionsAction.getCategoryElement(categoryMap, el, metaData, key, metaData.myCategory.length - 1);
                    element.addContent(metadataElement);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            try {
                JDOMUtil.writeDocument((Document)new Document(el), (File)new File(root, "intentions.xml"), (String)"\n");
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    private static Element getCategoryElement(Map<String, Element> categoryMap, Element rootElement, IntentionActionMetaData metaData, String key, int idx) {
        Element element = categoryMap.get(key);
        if (element == null) {
            element = new Element("category");
            element.setAttribute("name", metaData.myCategory[idx]);
            categoryMap.put(key, element);
            if (idx == 0) {
                rootElement.addContent(element);
            } else {
                DumpIntentionsAction.getCategoryElement(categoryMap, rootElement, metaData, StringUtil.join((String[])metaData.myCategory, (int)0, (int)(metaData.myCategory.length - 1), (String)"."), idx - 1).addContent(element);
            }
        }
        return element;
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabled(e.getData(CommonDataKeys.PROJECT) != null);
    }
}

