/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.lang.HtmlScriptContentProvider;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageHtmlScriptContentProvider;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lexer.DelegateLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xml.util.documentation.HtmlDescriptorsTable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class BaseHtmlLexer
extends DelegateLexer {
    protected static final int BASE_STATE_MASK = 63;
    private static final int SEEN_STYLE = 64;
    private static final int SEEN_TAG = 128;
    private static final int SEEN_SCRIPT = 256;
    private static final int SEEN_ATTRIBUTE = 512;
    private static final int SEEN_CONTENT_TYPE = 1024;
    protected static final int BASE_STATE_SHIFT = 11;
    @Nullable
    protected static final Language ourDefaultLanguage = Language.findLanguageByID((String)"JavaScript");
    private boolean seenTag;
    private boolean seenAttribute;
    private boolean seenStyle;
    private boolean seenScript;
    @Nullable
    protected String scriptType = null;
    private final boolean caseInsensitive;
    private boolean seenContentType;
    private CharSequence cachedBufferSequence;
    private Lexer lexerOfCacheBufferSequence;
    static final TokenSet TOKENS_TO_MERGE = TokenSet.create((IElementType[])new IElementType[]{XmlTokenType.XML_COMMENT_CHARACTERS, XmlTokenType.XML_WHITE_SPACE, XmlTokenType.XML_REAL_WHITE_SPACE, XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN, XmlTokenType.XML_DATA_CHARACTERS, XmlTokenType.XML_TAG_CHARACTERS});
    private final HashMap<IElementType, TokenHandler> tokenHandlers = new HashMap();

    @Nullable
    protected Language getScriptLanguage() {
        Collection instancesByMimeType = Language.findInstancesByMimeType(this.scriptType != null ? this.scriptType.trim() : null);
        return instancesByMimeType.isEmpty() ? null : (Language)instancesByMimeType.iterator().next();
    }

    @Nullable
    protected IElementType getCurrentScriptElementType() {
        HtmlScriptContentProvider scriptContentProvider = BaseHtmlLexer.findScriptContentProvider(this.scriptType);
        return scriptContentProvider == null ? null : scriptContentProvider.getScriptElementType();
    }

    @Nullable
    protected static HtmlScriptContentProvider findScriptContentProvider(@Nullable String mimeType) {
        if (StringUtil.isEmpty((String)mimeType)) {
            return ourDefaultLanguage != null ? LanguageHtmlScriptContentProvider.getScriptContentProvider(ourDefaultLanguage) : null;
        }
        List<HTMLLanguage> instancesByMimeType = Language.findInstancesByMimeType((String)mimeType.trim());
        if (instancesByMimeType.isEmpty() && mimeType.contains("template")) {
            instancesByMimeType = Collections.singletonList(HTMLLanguage.INSTANCE);
        }
        for (Language language : instancesByMimeType) {
            HtmlScriptContentProvider scriptContentProvider = LanguageHtmlScriptContentProvider.getScriptContentProvider(language);
            if (scriptContentProvider == null) continue;
            return scriptContentProvider;
        }
        return null;
    }

    protected BaseHtmlLexer(Lexer _baseLexer, boolean _caseInsensitive) {
        super(_baseLexer);
        this.caseInsensitive = _caseInsensitive;
        XmlNameHandler value = new XmlNameHandler();
        this.tokenHandlers.put(XmlTokenType.XML_NAME, value);
        this.tokenHandlers.put(XmlTokenType.XML_TAG_NAME, value);
        this.tokenHandlers.put(XmlTokenType.XML_TAG_END, new XmlTagClosedHandler());
        this.tokenHandlers.put(XmlTokenType.XML_END_TAG_START, new XmlTagEndHandler());
        this.tokenHandlers.put(XmlTokenType.XML_EMPTY_ELEMENT_END, new XmlTagEndHandler());
        this.tokenHandlers.put(XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER, new XmlAttributeValueEndHandler());
        this.tokenHandlers.put(XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN, new XmlAttributeValueHandler());
    }

    protected void registerHandler(IElementType elementType, TokenHandler value) {
        final TokenHandler tokenHandler = this.tokenHandlers.get(elementType);
        if (tokenHandler != null) {
            final TokenHandler newHandler = value;
            value = new TokenHandler(){

                @Override
                public void handleElement(Lexer lexer) {
                    tokenHandler.handleElement(lexer);
                    newHandler.handleElement(lexer);
                }
            };
        }
        this.tokenHandlers.put(elementType, value);
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/lexer/BaseHtmlLexer", "start"));
        }
        this.initState(initialState);
        super.start(buffer, startOffset, endOffset, initialState & 0x3F);
    }

    private void initState(int initialState) {
        this.seenScript = (initialState & 0x100) != 0;
        this.seenStyle = (initialState & 0x40) != 0;
        this.seenTag = (initialState & 0x80) != 0;
        this.seenAttribute = (initialState & 0x200) != 0;
        this.seenContentType = (initialState & 0x400) != 0;
        this.lexerOfCacheBufferSequence = null;
        this.cachedBufferSequence = null;
    }

    protected int skipToTheEndOfTheEmbeddment() {
        Lexer base = this.getDelegate();
        int tokenEnd = base.getTokenEnd();
        int lastState = 0;
        int lastStart = 0;
        CharSequence buf = base.getBufferSequence();
        char[] bufArray = CharArrayUtil.fromSequenceWithoutCopying((CharSequence)buf);
        if (this.seenTag) {
            while (true) {
                block13: {
                    if (base.getTokenType() != XmlTokenType.XML_END_TAG_START) {
                        if (base.getTokenType() == XmlTokenType.XML_COMMENT_CHARACTERS) {
                            int end = base.getTokenEnd();
                            for (int i = base.getTokenStart(); i < end; ++i) {
                                if ((bufArray != null ? bufArray[i] : buf.charAt(i)) != '<' || i + 1 >= end || (bufArray != null ? bufArray[i + 1] : buf.charAt(i + 1)) != '/') continue;
                                tokenEnd = i;
                                lastStart = i - 1;
                                lastState = 0;
                                break block13;
                            }
                        }
                        lastState = base.getState();
                        tokenEnd = base.getTokenEnd();
                        lastStart = base.getTokenStart();
                        if (tokenEnd != this.getBufferEnd()) {
                            base.advance();
                            continue;
                        }
                        break;
                    }
                }
                if (base.getTokenType() != XmlTokenType.XML_END_TAG_START) {
                    base.start(buf, lastStart + 1, this.getBufferEnd(), lastState);
                    base.getTokenType();
                    base.advance();
                } else {
                    base.advance();
                }
                while (XmlTokenType.WHITESPACES.contains(base.getTokenType())) {
                    base.advance();
                }
                if (base.getTokenType() != XmlTokenType.XML_NAME) continue;
                String name = TreeUtil.getTokenText(base);
                if (this.caseInsensitive) {
                    name = name.toLowerCase();
                }
                if (this.hasSeenScript() && "script".equals(name) || this.hasSeenStyle() && "style".equals(name) || "IntellijIdeaRulezzz".equalsIgnoreCase(name)) break;
            }
            base.start(buf, lastStart, this.getBufferEnd(), lastState);
            base.getTokenType();
        } else if (this.seenAttribute) {
            while (this.isValidAttributeValueTokenType(base.getTokenType())) {
                tokenEnd = base.getTokenEnd();
                lastState = base.getState();
                lastStart = base.getTokenStart();
                if (tokenEnd == this.getBufferEnd()) break;
                base.advance();
            }
            base.start(buf, lastStart, this.getBufferEnd(), lastState);
            base.getTokenType();
        }
        return tokenEnd;
    }

    protected boolean isValidAttributeValueTokenType(IElementType tokenType) {
        return tokenType == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN || tokenType == XmlTokenType.XML_ENTITY_REF_TOKEN || tokenType == XmlTokenType.XML_CHAR_ENTITY_REF;
    }

    public void advance() {
        super.advance();
        IElementType type = this.getDelegate().getTokenType();
        TokenHandler tokenHandler = this.tokenHandlers.get(type);
        if (tokenHandler != null) {
            tokenHandler.handleElement((Lexer)this);
        }
    }

    public int getState() {
        int state = super.getState();
        state |= this.seenScript ? 256 : 0;
        state |= this.seenTag ? 128 : 0;
        state |= this.seenStyle ? 64 : 0;
        state |= this.seenAttribute ? 512 : 0;
        return state |= this.seenContentType ? 1024 : 0;
    }

    protected final boolean hasSeenStyle() {
        return this.seenStyle;
    }

    protected final boolean hasSeenAttribute() {
        return this.seenAttribute;
    }

    protected final boolean hasSeenTag() {
        return this.seenTag;
    }

    protected boolean hasSeenScript() {
        return this.seenScript;
    }

    protected abstract boolean isHtmlTagState(int var1);

    class XmlTagEndHandler
    implements TokenHandler {
        XmlTagEndHandler() {
        }

        @Override
        public void handleElement(Lexer lexer) {
            BaseHtmlLexer.this.seenStyle = false;
            BaseHtmlLexer.this.seenScript = false;
            BaseHtmlLexer.this.seenAttribute = false;
            BaseHtmlLexer.this.seenContentType = false;
            BaseHtmlLexer.this.scriptType = null;
        }
    }

    class XmlTagClosedHandler
    implements TokenHandler {
        XmlTagClosedHandler() {
        }

        @Override
        public void handleElement(Lexer lexer) {
            if (BaseHtmlLexer.this.seenAttribute) {
                BaseHtmlLexer.this.seenScript = false;
                BaseHtmlLexer.this.seenStyle = false;
                BaseHtmlLexer.this.seenAttribute = false;
            } else if (BaseHtmlLexer.this.seenStyle || BaseHtmlLexer.this.seenScript) {
                BaseHtmlLexer.this.seenTag = true;
            }
        }
    }

    class XmlAttributeValueHandler
    implements TokenHandler {
        XmlAttributeValueHandler() {
        }

        @Override
        public void handleElement(Lexer lexer) {
            if (BaseHtmlLexer.this.seenContentType) {
                if (!BaseHtmlLexer.this.seenScript || BaseHtmlLexer.this.seenAttribute) {
                    return;
                }
                String mimeType = TreeUtil.getTokenText(lexer);
                if (BaseHtmlLexer.this.caseInsensitive) {
                    mimeType = mimeType.toLowerCase();
                }
                BaseHtmlLexer.this.scriptType = mimeType;
            }
        }
    }

    class XmlAttributeValueEndHandler
    implements TokenHandler {
        XmlAttributeValueEndHandler() {
        }

        @Override
        public void handleElement(Lexer lexer) {
            if (BaseHtmlLexer.this.seenAttribute) {
                BaseHtmlLexer.this.seenStyle = false;
                BaseHtmlLexer.this.seenScript = false;
                BaseHtmlLexer.this.seenAttribute = false;
            }
            BaseHtmlLexer.this.seenContentType = false;
        }
    }

    public class XmlNameHandler
    implements TokenHandler {
        @NonNls
        private static final String TOKEN_SCRIPT = "script";
        @NonNls
        private static final String TOKEN_STYLE = "style";
        @NonNls
        private static final String TOKEN_ON = "on";

        @Override
        public void handleElement(Lexer lexer) {
            boolean script;
            CharSequence buffer;
            if (BaseHtmlLexer.this.lexerOfCacheBufferSequence == lexer) {
                buffer = BaseHtmlLexer.this.cachedBufferSequence;
            } else {
                BaseHtmlLexer.this.cachedBufferSequence = lexer.getBufferSequence();
                buffer = BaseHtmlLexer.this.cachedBufferSequence;
                BaseHtmlLexer.this.lexerOfCacheBufferSequence = lexer;
            }
            char firstCh = buffer.charAt(lexer.getTokenStart());
            if (BaseHtmlLexer.this.seenScript && !BaseHtmlLexer.this.seenTag) {
                BaseHtmlLexer.this.seenContentType = false;
                if (firstCh == 'l' || firstCh == 't' || BaseHtmlLexer.this.caseInsensitive && (firstCh == 'L' || firstCh == 'T')) {
                    String name = TreeUtil.getTokenText(lexer);
                    if (BaseHtmlLexer.this.caseInsensitive) {
                        name = name.toLowerCase();
                    }
                    if ("language".equals(name) || "type".equals(name)) {
                        BaseHtmlLexer.this.seenContentType = true;
                    }
                }
                return;
            }
            if (firstCh != 'o' && firstCh != 's' && (!BaseHtmlLexer.this.caseInsensitive || firstCh != 'S' && firstCh != 'O')) {
                return;
            }
            String name = TreeUtil.getTokenText(lexer);
            if (BaseHtmlLexer.this.caseInsensitive) {
                name = name.toLowerCase();
            }
            boolean style = name.equals(TOKEN_STYLE);
            int state = BaseHtmlLexer.this.getState() & 0x3F;
            boolean bl = script = name.equals(TOKEN_SCRIPT) || name.startsWith(TOKEN_ON) && name.indexOf(58) == -1 && !BaseHtmlLexer.this.isHtmlTagState(state) && HtmlDescriptorsTable.getAttributeDescriptor(name) != null;
            if (style || script) {
                if (BaseHtmlLexer.this.seenTag) {
                    if (BaseHtmlLexer.this.isHtmlTagState(state)) {
                        BaseHtmlLexer.this.seenTag = false;
                    }
                    return;
                }
                BaseHtmlLexer.this.seenStyle = style;
                BaseHtmlLexer.this.seenScript = script;
                if (!BaseHtmlLexer.this.isHtmlTagState(state)) {
                    BaseHtmlLexer.this.seenAttribute = true;
                }
            }
        }
    }

    public static interface TokenHandler {
        public void handleElement(Lexer var1);
    }
}

