/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl;

import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.notification.impl.NotificationSettings;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.messages.MessageBus;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="NotificationConfiguration", storages={@Storage(file="$APP_CONFIG$/notifications.xml")})
public class NotificationsConfigurationImpl
extends NotificationsConfiguration
implements ApplicationComponent,
PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(NotificationsConfiguration.class);
    private static final String SHOW_BALLOONS_ATTRIBUTE = "showBalloons";
    private static final String SYSTEM_NOTIFICATIONS_ATTRIBUTE = "systemNotifications";
    private static final Comparator<NotificationSettings> NOTIFICATION_SETTINGS_COMPARATOR = new Comparator<NotificationSettings>(){

        @Override
        public int compare(@NotNull NotificationSettings o1, @NotNull NotificationSettings o2) {
            if (o1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/notification/impl/NotificationsConfigurationImpl$1", "compare"));
            }
            if (o2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/notification/impl/NotificationsConfigurationImpl$1", "compare"));
            }
            return o1.getGroupId().compareToIgnoreCase(o2.getGroupId());
        }
    };
    private final Map<String, NotificationSettings> myIdToSettingsMap;
    private final Map<String, String> myToolWindowCapable;
    private final MessageBus myMessageBus;
    public boolean SHOW_BALLOONS;
    public boolean SYSTEM_NOTIFICATIONS;

    public NotificationsConfigurationImpl(@NotNull MessageBus bus) {
        if (bus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bus", "com/intellij/notification/impl/NotificationsConfigurationImpl", "<init>"));
        }
        this.myIdToSettingsMap = new THashMap();
        this.myToolWindowCapable = new THashMap();
        this.SHOW_BALLOONS = true;
        this.SYSTEM_NOTIFICATIONS = true;
        this.myMessageBus = bus;
    }

    public static NotificationsConfigurationImpl getInstanceImpl() {
        return (NotificationsConfigurationImpl)NotificationsConfigurationImpl.getNotificationsConfiguration();
    }

    public synchronized boolean hasToolWindowCapability(@NotNull String groupId) {
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "com/intellij/notification/impl/NotificationsConfigurationImpl", "hasToolWindowCapability"));
        }
        return this.getToolWindowId(groupId) != null || this.myToolWindowCapable.containsKey(groupId);
    }

    @Nullable
    public String getToolWindowId(@NotNull String groupId) {
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "com/intellij/notification/impl/NotificationsConfigurationImpl", "getToolWindowId"));
        }
        NotificationGroup group = NotificationGroup.findRegisteredGroup((String)groupId);
        return group == null ? null : group.getToolWindowId();
    }

    public synchronized NotificationSettings[] getAllSettings() {
        THashSet settings = new THashSet(this.myIdToSettingsMap.values());
        for (NotificationGroup group : NotificationGroup.getAllRegisteredGroups()) {
            settings.add(NotificationsConfigurationImpl.getSettings(group.getDisplayId()));
        }
        NotificationSettings[] result2 = settings.toArray(new NotificationSettings[settings.size()]);
        Arrays.sort(result2, NOTIFICATION_SETTINGS_COMPARATOR);
        return result2;
    }

    public static void remove(String ... toRemove) {
        NotificationsConfigurationImpl.getInstanceImpl().doRemove(toRemove);
    }

    private synchronized void doRemove(String ... toRemove) {
        for (String groupId : toRemove) {
            this.myIdToSettingsMap.remove(groupId);
            this.myToolWindowCapable.remove(groupId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static NotificationSettings getSettings(@NotNull String groupId) {
        NotificationSettings settings;
        NotificationsConfigurationImpl impl;
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "com/intellij/notification/impl/NotificationsConfigurationImpl", "getSettings"));
        }
        NotificationsConfigurationImpl notificationsConfigurationImpl = impl = NotificationsConfigurationImpl.getInstanceImpl();
        synchronized (notificationsConfigurationImpl) {
            settings = impl.myIdToSettingsMap.get(groupId);
        }
        NotificationSettings notificationSettings = settings == null ? NotificationsConfigurationImpl.getDefaultSettings(groupId) : settings;
        if (notificationSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/impl/NotificationsConfigurationImpl", "getSettings"));
        }
        return notificationSettings;
    }

    @NotNull
    private static NotificationSettings getDefaultSettings(String groupId) {
        NotificationGroup group = NotificationGroup.findRegisteredGroup((String)groupId);
        if (group != null) {
            NotificationSettings notificationSettings = new NotificationSettings(groupId, group.getDisplayType(), group.isLogByDefault(), false);
            if (notificationSettings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/impl/NotificationsConfigurationImpl", "getDefaultSettings"));
            }
            return notificationSettings;
        }
        NotificationSettings notificationSettings = new NotificationSettings(groupId, NotificationDisplayType.BALLOON, true, false);
        if (notificationSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/impl/NotificationsConfigurationImpl", "getDefaultSettings"));
        }
        return notificationSettings;
    }

    @NotNull
    public String getComponentName() {
        if ("NotificationsConfiguration" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/impl/NotificationsConfigurationImpl", "getComponentName"));
        }
        return "NotificationsConfiguration";
    }

    public void initComponent() {
        this.myMessageBus.connect().subscribe(TOPIC, (Object)this);
    }

    public synchronized void disposeComponent() {
        this.myIdToSettingsMap.clear();
    }

    public void register(@NotNull String groupDisplayName, @NotNull NotificationDisplayType displayType) {
        if (groupDisplayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupDisplayName", "com/intellij/notification/impl/NotificationsConfigurationImpl", "register"));
        }
        if (displayType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayType", "com/intellij/notification/impl/NotificationsConfigurationImpl", "register"));
        }
        this.register(groupDisplayName, displayType, true);
    }

    public void register(@NotNull String groupDisplayName, @NotNull NotificationDisplayType displayType, boolean shouldLog) {
        if (groupDisplayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupDisplayName", "com/intellij/notification/impl/NotificationsConfigurationImpl", "register"));
        }
        if (displayType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayType", "com/intellij/notification/impl/NotificationsConfigurationImpl", "register"));
        }
        this.register(groupDisplayName, displayType, shouldLog, false);
    }

    public void register(@NotNull String groupDisplayName, @NotNull NotificationDisplayType displayType, boolean shouldLog, boolean shouldReadAloud) {
        if (groupDisplayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupDisplayName", "com/intellij/notification/impl/NotificationsConfigurationImpl", "register"));
        }
        if (displayType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayType", "com/intellij/notification/impl/NotificationsConfigurationImpl", "register"));
        }
        if (!this.isRegistered(groupDisplayName)) {
            new NotificationGroup(groupDisplayName, displayType, shouldLog);
            this.changeSettings(groupDisplayName, displayType, shouldLog, shouldReadAloud);
        } else if (displayType == NotificationDisplayType.TOOL_WINDOW && !this.hasToolWindowCapability(groupDisplayName)) {
            this.changeSettings(NotificationsConfigurationImpl.getSettings(groupDisplayName).withDisplayType(NotificationDisplayType.TOOL_WINDOW));
            this.myToolWindowCapable.put(groupDisplayName, null);
        }
    }

    public void changeSettings(String groupDisplayName, NotificationDisplayType displayType, boolean shouldLog, boolean shouldReadAloud) {
        this.changeSettings(new NotificationSettings(groupDisplayName, displayType, shouldLog, shouldReadAloud));
    }

    public synchronized void changeSettings(NotificationSettings settings) {
        String groupDisplayName = settings.getGroupId();
        if (settings.equals(NotificationsConfigurationImpl.getDefaultSettings(groupDisplayName))) {
            this.myIdToSettingsMap.remove(groupDisplayName);
        } else {
            this.myIdToSettingsMap.put(groupDisplayName, settings);
        }
    }

    public synchronized boolean isRegistered(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/notification/impl/NotificationsConfigurationImpl", "isRegistered"));
        }
        return this.myIdToSettingsMap.containsKey(id) || NotificationGroup.findRegisteredGroup((String)id) != null;
    }

    public synchronized Element getState() {
        Element element = new Element("NotificationsConfiguration");
        NotificationSettings[] sortedNotifications = this.myIdToSettingsMap.values().toArray(new NotificationSettings[this.myIdToSettingsMap.size()]);
        Arrays.sort(sortedNotifications, NOTIFICATION_SETTINGS_COMPARATOR);
        for (NotificationSettings settings : sortedNotifications) {
            element.addContent(settings.save());
        }
        if (!this.SHOW_BALLOONS) {
            element.setAttribute(SHOW_BALLOONS_ATTRIBUTE, "false");
        }
        if (!this.SYSTEM_NOTIFICATIONS) {
            element.setAttribute(SYSTEM_NOTIFICATIONS_ATTRIBUTE, "false");
        }
        return element;
    }

    public synchronized void loadState(Element state) {
        this.myIdToSettingsMap.clear();
        for (Element child : state.getChildren("notification")) {
            NotificationSettings settings = NotificationSettings.load(child);
            if (settings == null) continue;
            String id = settings.getGroupId();
            LOG.assertTrue(!this.myIdToSettingsMap.containsKey(id), (Object)String.format("Settings for '%s' already loaded!", id));
            this.myIdToSettingsMap.put(id, settings);
        }
        this.doRemove("Log Only");
        if ("false".equals(state.getAttributeValue(SHOW_BALLOONS_ATTRIBUTE))) {
            this.SHOW_BALLOONS = false;
        }
        if ("false".equals(state.getAttributeValue(SYSTEM_NOTIFICATIONS_ATTRIBUTE))) {
            this.SYSTEM_NOTIFICATIONS = false;
        }
    }
}

