/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.application.options.PathMacrosCollector;
import com.intellij.openapi.components.PathMacroSubstitutor;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.StringInterner;
import java.util.List;
import java.util.TreeMap;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileStorageCoreUtil {
    private static final Logger LOG = Logger.getInstance(FileStorageCoreUtil.class);
    public static final String COMPONENT = "component";
    public static final String NAME = "name";
    public static final String DEFAULT_EXT = ".xml";

    @NotNull
    public static TreeMap<String, Element> load(@NotNull Element rootElement, @Nullable PathMacroSubstitutor pathMacroSubstitutor, boolean intern) {
        if (rootElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "com/intellij/openapi/components/impl/stores/FileStorageCoreUtil", "load"));
        }
        if (pathMacroSubstitutor != null) {
            pathMacroSubstitutor.expandPaths(rootElement);
        }
        StringInterner interner = intern ? new StringInterner() : null;
        List children2 = rootElement.getChildren(COMPONENT);
        TreeMap<String, Element> map = new TreeMap<String, Element>();
        for (Element element : children2) {
            String name = FileStorageCoreUtil.getComponentNameIfValid(element);
            if (name == null || element.getAttributes().size() <= 1 && element.getChildren().isEmpty()) continue;
            if (interner != null) {
                JDOMUtil.internElement((Element)element, (StringInterner)interner);
            }
            map.put(name, element);
            if (pathMacroSubstitutor instanceof TrackingPathMacroSubstitutor) {
                ((TrackingPathMacroSubstitutor)pathMacroSubstitutor).addUnknownMacros(name, PathMacrosCollector.getMacroNames(element));
            }
            element.removeAttribute(NAME);
        }
        TreeMap<String, Element> treeMap = map;
        if (treeMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/FileStorageCoreUtil", "load"));
        }
        return treeMap;
    }

    @Nullable
    static String getComponentNameIfValid(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/components/impl/stores/FileStorageCoreUtil", "getComponentNameIfValid"));
        }
        String name = element.getAttributeValue(NAME);
        if (StringUtil.isEmpty((String)name)) {
            LOG.warn("No name attribute for component in " + JDOMUtil.writeElement((Element)element));
            return null;
        }
        return name;
    }
}

