/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.dir.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.diff.impl.dir.DirDiffTableModel;
import org.jetbrains.annotations.Nullable;

public abstract class DirDiffAction
extends ToggleAction
implements ShortcutProvider {
    private final DirDiffTableModel myModel;

    protected DirDiffAction(DirDiffTableModel model) {
        this.myModel = model;
    }

    public DirDiffTableModel getModel() {
        return this.myModel;
    }

    protected abstract void updateState(boolean var1);

    public final void setSelected(AnActionEvent e, boolean state) {
        this.updateState(state);
        if (this.isReloadNeeded()) {
            if (this.isFullReload()) {
                this.getModel().reloadModel(true);
            } else if (state) {
                this.getModel().applySettings();
            } else {
                this.getModel().applyRemove();
            }
        }
        this.getModel().updateFromUI();
    }

    protected boolean isFullReload() {
        return false;
    }

    protected boolean isReloadNeeded() {
        return true;
    }

    public void update(AnActionEvent e) {
        super.update(e);
        e.getPresentation().setEnabled(!this.getModel().isUpdating());
    }

    @Nullable
    public ShortcutSet getShortcut() {
        return this.getShortcutSet();
    }
}

