/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.incrementalMerge;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeHighlighterHolder;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeList;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeSide;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeType;
import com.intellij.openapi.diff.impl.incrementalMerge.DiffRangeMarker;
import com.intellij.openapi.diff.impl.util.DocumentUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Change {
    private static final Logger LOG = Logger.getInstance(Change.class);

    public abstract ChangeSide getChangeSide(FragmentSide var1);

    public abstract ChangeType getType();

    public abstract ChangeList getChangeList();

    protected abstract void removeFromList();

    public abstract void onApplied();

    public abstract void onRemovedFromList();

    public abstract boolean isValid();

    private void apply(@NotNull FragmentSide original) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/openapi/diff/impl/incrementalMerge/Change", "apply"));
        }
        FragmentSide targetSide = original.otherSide();
        RangeMarker originalRangeMarker = this.getRangeMarker(original);
        RangeMarker rangeMarker = this.getRangeMarker(targetSide);
        TextRange textRange = Change.modifyDocument(this.getProject(), originalRangeMarker, rangeMarker);
        if (textRange != null && this.isValid()) {
            this.updateTargetRangeMarker(targetSide, textRange);
        }
        this.onApplied();
    }

    protected final void updateTargetRangeMarker(@NotNull FragmentSide targetFragmentSide, @NotNull TextRange updatedTextRange) {
        if (targetFragmentSide == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetFragmentSide", "com/intellij/openapi/diff/impl/incrementalMerge/Change", "updateTargetRangeMarker"));
        }
        if (updatedTextRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updatedTextRange", "com/intellij/openapi/diff/impl/incrementalMerge/Change", "updateTargetRangeMarker"));
        }
        ChangeSide targetSide = this.getChangeSide(targetFragmentSide);
        DiffRangeMarker originalRange = targetSide.getRange();
        DiffRangeMarker updatedRange = new DiffRangeMarker(originalRange.getDocument(), updatedTextRange, null);
        this.changeSide(targetSide, updatedRange);
    }

    protected abstract void changeSide(ChangeSide var1, DiffRangeMarker var2);

    @Nullable
    private static TextRange modifyDocument(@Nullable Project project, @NotNull RangeMarker original, @NotNull RangeMarker target) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/openapi/diff/impl/incrementalMerge/Change", "modifyDocument"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/openapi/diff/impl/incrementalMerge/Change", "modifyDocument"));
        }
        Document document = target.getDocument();
        if (project != null && !ReadonlyStatusHandler.ensureDocumentWritable((Project)project, (Document)document)) {
            return null;
        }
        if (DocumentUtil.isEmpty(original)) {
            int offset = target.getStartOffset();
            document.deleteString(offset, target.getEndOffset());
        }
        CharSequence text = original.getDocument().getImmutableCharSequence().subSequence(original.getStartOffset(), original.getEndOffset());
        int startOffset = target.getStartOffset();
        if (DocumentUtil.isEmpty(target)) {
            document.insertString(startOffset, text);
        } else {
            document.replaceString(startOffset, target.getEndOffset(), text);
        }
        return new TextRange(startOffset, startOffset + text.length());
    }

    public void addMarkup(Editor[] editors) {
        LOG.assertTrue(editors.length == 2);
        this.highlight(editors, FragmentSide.SIDE1);
        this.highlight(editors, FragmentSide.SIDE2);
    }

    private void highlight(Editor[] editors, FragmentSide side) {
        this.getHighlighterHolder(side).highlight(this.getChangeSide(side), editors[side.getIndex()], this.getType());
    }

    private void updateHighlighter(FragmentSide side) {
        this.getHighlighterHolder(side).updateHighlighter(this.getChangeSide(side), this.getType());
    }

    @Nullable
    private Project getProject() {
        return this.getChangeList().getProject();
    }

    @NotNull
    private ChangeHighlighterHolder getHighlighterHolder(FragmentSide side) {
        ChangeHighlighterHolder changeHighlighterHolder = this.getChangeSide(side).getHighlighterHolder();
        if (changeHighlighterHolder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/incrementalMerge/Change", "getHighlighterHolder"));
        }
        return changeHighlighterHolder;
    }

    @NotNull
    private RangeMarker getRangeMarker(FragmentSide side) {
        ChangeSide changeSide = this.getChangeSide(side);
        LOG.assertTrue(changeSide != null);
        DiffRangeMarker diffRangeMarker = changeSide.getRange();
        if (diffRangeMarker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/incrementalMerge/Change", "getRangeMarker"));
        }
        return diffRangeMarker;
    }

    public static void apply(final Change change, final FragmentSide fromSide) {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                CommandProcessor.getInstance().executeCommand(change.getProject(), new Runnable(){

                    @Override
                    public void run() {
                        Change.doApply(change, fromSide);
                    }
                }, null, (Object)DiffBundle.message((String)"save.merge.result.command.name", (Object[])new Object[0]));
            }
        });
    }

    public static void doApply(Change change, FragmentSide fromSide) {
        change.apply(fromSide);
    }

    public void updateMarkup() {
        this.updateHighlighter(FragmentSide.SIDE1);
        this.updateHighlighter(FragmentSide.SIDE2);
    }

    public boolean canHasActions(FragmentSide fromSide) {
        FragmentSide targetSide = fromSide.otherSide();
        Document targetDocument = this.getChangeList().getDocument(targetSide);
        if (!targetDocument.isWritable()) {
            return false;
        }
        Editor targetEditor = this.getHighlighterHolder(targetSide).getEditor();
        return !targetEditor.isViewer();
    }

    protected static class SimpleChangeSide
    extends ChangeSide {
        private final FragmentSide mySide;
        private final DiffRangeMarker myRange;
        private final ChangeHighlighterHolder myHighlighterHolder;

        public SimpleChangeSide(FragmentSide side, DiffRangeMarker rangeMarker) {
            this.mySide = side;
            this.myRange = rangeMarker;
            this.myHighlighterHolder = new ChangeHighlighterHolder();
        }

        public SimpleChangeSide(@NotNull ChangeSide originalSide, @NotNull DiffRangeMarker newRange) {
            if (originalSide == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalSide", "com/intellij/openapi/diff/impl/incrementalMerge/Change$SimpleChangeSide", "<init>"));
            }
            if (newRange == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newRange", "com/intellij/openapi/diff/impl/incrementalMerge/Change$SimpleChangeSide", "<init>"));
            }
            this.mySide = ((SimpleChangeSide)originalSide).getFragmentSide();
            this.myRange = newRange;
            this.myHighlighterHolder = originalSide.getHighlighterHolder();
        }

        @NotNull
        public FragmentSide getFragmentSide() {
            FragmentSide fragmentSide = this.mySide;
            if (fragmentSide == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/incrementalMerge/Change$SimpleChangeSide", "getFragmentSide"));
            }
            return fragmentSide;
        }

        @Override
        @NotNull
        public DiffRangeMarker getRange() {
            DiffRangeMarker diffRangeMarker = this.myRange;
            if (diffRangeMarker == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/incrementalMerge/Change$SimpleChangeSide", "getRange"));
            }
            return diffRangeMarker;
        }

        @Override
        @NotNull
        public ChangeHighlighterHolder getHighlighterHolder() {
            ChangeHighlighterHolder changeHighlighterHolder = this.myHighlighterHolder;
            if (changeHighlighterHolder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/incrementalMerge/Change$SimpleChangeSide", "getHighlighterHolder"));
            }
            return changeHighlighterHolder;
        }
    }

    public static class ChangeOrder
    implements Comparator<Change> {
        private final FragmentSide myMainSide;

        public ChangeOrder(FragmentSide mainSide) {
            this.myMainSide = mainSide;
        }

        @Override
        public int compare(@NotNull Change change, @NotNull Change change1) {
            if (change == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/diff/impl/incrementalMerge/Change$ChangeOrder", "compare"));
            }
            if (change1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change1", "com/intellij/openapi/diff/impl/incrementalMerge/Change$ChangeOrder", "compare"));
            }
            int result1 = ChangeOrder.compareSide(change, change1, this.myMainSide);
            if (result1 != 0) {
                return result1;
            }
            return ChangeOrder.compareSide(change, change1, this.myMainSide.otherSide());
        }

        private static int compareSide(Change change, Change change1, FragmentSide side) {
            return RangeMarker.BY_START_OFFSET.compare(change.getRangeMarker(side), change1.getRangeMarker(side));
        }
    }
}

