/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.incrementalMerge;

import com.intellij.openapi.diff.impl.incrementalMerge.ChangeHighlighterHolder;
import com.intellij.openapi.diff.impl.incrementalMerge.DiffRangeMarker;
import com.intellij.openapi.diff.impl.util.DocumentUtil;
import org.jetbrains.annotations.NotNull;

public abstract class ChangeSide {
    public int getStart() {
        return this.getRange().getStartOffset();
    }

    public int getStartLine() {
        return DocumentUtil.getStartLine(this.getRange());
    }

    @NotNull
    public CharSequence getText() {
        DiffRangeMarker range = this.getRange();
        CharSequence charSequence = range.getDocument().getCharsSequence().subSequence(range.getStartOffset(), range.getEndOffset());
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/incrementalMerge/ChangeSide", "getText"));
        }
        return charSequence;
    }

    public int getEndLine() {
        return DocumentUtil.getEndLine(this.getRange());
    }

    @NotNull
    public abstract DiffRangeMarker getRange();

    @NotNull
    public abstract ChangeHighlighterHolder getHighlighterHolder();

    public boolean contains(int offset) {
        return this.getStart() <= offset && offset < this.getEnd();
    }

    public int getEnd() {
        return this.getRange().getEndOffset();
    }
}

