/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.util;

import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.DiffColors;
import com.intellij.openapi.diff.ex.DiffStatusBar;
import com.intellij.openapi.diff.impl.util.TextDiffTypeEnum;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.util.containers.Convertor;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextDiffType
implements DiffStatusBar.LegendTypeDescriptor {
    public static final TextDiffType INSERT = new TextDiffType(TextDiffTypeEnum.INSERT, DiffBundle.message((String)"diff.type.inserted.name", (Object[])new Object[0]), DiffColors.DIFF_INSERTED);
    public static final TextDiffType CHANGED = new TextDiffType(TextDiffTypeEnum.CHANGED, DiffBundle.message((String)"diff.type.changed.name", (Object[])new Object[0]), DiffColors.DIFF_MODIFIED);
    public static final TextDiffType DELETED = new TextDiffType(TextDiffTypeEnum.DELETED, DiffBundle.message((String)"diff.type.deleted.name", (Object[])new Object[0]), DiffColors.DIFF_DELETED);
    public static final TextDiffType CONFLICT = new TextDiffType(TextDiffTypeEnum.CONFLICT, DiffBundle.message((String)"diff.type.conflict.name", (Object[])new Object[0]), DiffColors.DIFF_CONFLICT);
    public static final TextDiffType NONE = new TextDiffType(TextDiffTypeEnum.NONE, DiffBundle.message((String)"diff.type.none.name", (Object[])new Object[0]), null);
    public static final List<TextDiffType> DIFF_TYPES = Arrays.asList(DELETED, CHANGED, INSERT);
    public static final List<TextDiffType> MERGE_TYPES = Arrays.asList(DELETED, CHANGED, INSERT, CONFLICT);
    public static final Convertor<TextDiffType, TextAttributesKey> ATTRIBUTES_KEY = new Convertor<TextDiffType, TextAttributesKey>(){

        public TextAttributesKey convert(TextDiffType textDiffType) {
            return textDiffType.getAttributesKey();
        }
    };
    private static final double MIDDLE_COLOR_FACTOR = 0.6;
    private final TextDiffTypeEnum myType;
    private final TextAttributesKey myAttributesKey;
    private final String myDisplayName;
    private final boolean myApplied;
    private final boolean myInlineWrapper;

    public boolean isApplied() {
        return this.myApplied;
    }

    public boolean isInlineWrapper() {
        return this.myInlineWrapper;
    }

    @NotNull
    public static TextDiffType create(@Nullable TextDiffTypeEnum type) {
        if (TextDiffTypeEnum.INSERT.equals((Object)type)) {
            TextDiffType textDiffType = INSERT;
            if (textDiffType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/util/TextDiffType", "create"));
            }
            return textDiffType;
        }
        if (TextDiffTypeEnum.CHANGED.equals((Object)type)) {
            TextDiffType textDiffType = CHANGED;
            if (textDiffType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/util/TextDiffType", "create"));
            }
            return textDiffType;
        }
        if (TextDiffTypeEnum.DELETED.equals((Object)type)) {
            TextDiffType textDiffType = DELETED;
            if (textDiffType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/util/TextDiffType", "create"));
            }
            return textDiffType;
        }
        if (TextDiffTypeEnum.CONFLICT.equals((Object)type)) {
            TextDiffType textDiffType = CONFLICT;
            if (textDiffType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/util/TextDiffType", "create"));
            }
            return textDiffType;
        }
        TextDiffType textDiffType = NONE;
        if (textDiffType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/util/TextDiffType", "create"));
        }
        return textDiffType;
    }

    @NotNull
    public static TextDiffType deriveApplied(@NotNull TextDiffType source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/openapi/diff/impl/util/TextDiffType", "deriveApplied"));
        }
        TextDiffType textDiffType = new TextDiffType(source.myType, source.myDisplayName, source.myAttributesKey, true, false);
        if (textDiffType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/util/TextDiffType", "deriveApplied"));
        }
        return textDiffType;
    }

    public static TextDiffType deriveInstanceForInlineWrapperFragment(@NotNull TextDiffType source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/openapi/diff/impl/util/TextDiffType", "deriveInstanceForInlineWrapperFragment"));
        }
        return new TextDiffType(source.myType, source.myDisplayName, source.myAttributesKey, source.myApplied, true);
    }

    private TextDiffType(TextDiffTypeEnum type, String displayName, TextAttributesKey attributesKey) {
        this(type, displayName, attributesKey, false, false);
    }

    private TextDiffType(TextDiffTypeEnum type, String displayName, TextAttributesKey attributesKey, boolean applied, boolean inlineWrapper) {
        this.myType = type;
        this.myAttributesKey = attributesKey;
        this.myDisplayName = displayName;
        this.myApplied = applied;
        this.myInlineWrapper = inlineWrapper;
    }

    @Override
    public String getDisplayName() {
        return this.myDisplayName;
    }

    @Override
    @Nullable
    public Color getLegendColor(EditorColorsScheme colorScheme) {
        TextAttributes attributes = colorScheme.getAttributes(this.myAttributesKey);
        return attributes != null ? attributes.getBackgroundColor() : null;
    }

    public TextAttributesKey getAttributesKey() {
        return this.myAttributesKey;
    }

    @Nullable
    public TextAttributes getTextAttributes(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/diff/impl/util/TextDiffType", "getTextAttributes"));
        }
        return scheme.getAttributes(this.myAttributesKey);
    }

    @Nullable
    public Color getPolygonColor(Editor editor) {
        if (this.isApplied()) {
            return this.getLegendColor(editor.getColorsScheme());
        }
        if (this.isInlineWrapper()) {
            return this.getBgColorForFragmentContainingInlines((EditorEx)editor);
        }
        TextAttributes attributes = this.getTextAttributes(editor);
        return attributes == null ? null : attributes.getBackgroundColor();
    }

    @Nullable
    public TextAttributes getTextAttributes(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/diff/impl/util/TextDiffType", "getTextAttributes"));
        }
        TextAttributes originalAttrs = this.getTextAttributes(editor.getColorsScheme());
        if (originalAttrs == null) {
            return null;
        }
        TextAttributes overridingAttributes = new TextAttributes();
        if (this.myApplied) {
            overridingAttributes.setBackgroundColor(((EditorEx)editor).getBackgroundColor());
        } else if (this.myInlineWrapper) {
            overridingAttributes.setBackgroundColor(this.getBgColorForFragmentContainingInlines((EditorEx)editor));
        }
        return TextAttributes.merge((TextAttributes)originalAttrs, (TextAttributes)overridingAttributes);
    }

    @Nullable
    public Color getTextBackground(Editor editor) {
        TextAttributes attributes = this.getTextAttributes(editor);
        return attributes != null ? attributes.getBackgroundColor() : null;
    }

    public String toString() {
        return this.myApplied ? this.myDisplayName + "_applied" : this.myDisplayName;
    }

    public TextDiffTypeEnum getType() {
        return this.myType;
    }

    @Nullable
    private Color getBgColorForFragmentContainingInlines(@NotNull EditorEx editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/diff/impl/util/TextDiffType", "getBgColorForFragmentContainingInlines"));
        }
        TextAttributes originalAttrs = this.getTextAttributes(editor.getColorsScheme());
        if (originalAttrs == null) {
            return null;
        }
        Color fg = originalAttrs.getBackgroundColor();
        if (fg == null) {
            return null;
        }
        Color bg = editor.getBackgroundColor();
        return TextDiffType.getMiddleColor(fg, bg, 0.6);
    }

    @NotNull
    private static Color getMiddleColor(Color fg, Color bg, double factor) {
        int red = TextDiffType.avg(fg.getRed(), bg.getRed(), factor);
        int green = TextDiffType.avg(fg.getGreen(), bg.getGreen(), factor);
        int blue = TextDiffType.avg(fg.getBlue(), bg.getBlue(), factor);
        Color color = new Color(red, green, blue);
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/util/TextDiffType", "getMiddleColor"));
        }
        return color;
    }

    private static int avg(int fg, int bg, double factor) {
        return (int)((long)fg + Math.round(factor * (double)(bg - fg)));
    }
}

