/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.ComplementaryFontsRegistry;
import com.intellij.openapi.editor.impl.EditorTextRepresentationHelper;
import com.intellij.openapi.editor.impl.FontInfo;
import gnu.trove.TObjectIntHashMap;
import org.intellij.lang.annotations.JdkConstants;

public class DefaultEditorTextRepresentationHelper
implements EditorTextRepresentationHelper {
    private static final int MAX_SYMBOLS_WIDTHS_CACHE_SIZE = 1000;
    private final TObjectIntHashMap<Key> mySymbolWidthCache = new TObjectIntHashMap();
    private final Key mySharedKey = new Key();
    private final Editor myEditor;

    public DefaultEditorTextRepresentationHelper(Editor editor) {
        this.myEditor = editor;
    }

    @Override
    public int toVisualColumnSymbolsNumber(int start, int end, int x) {
        return EditorUtil.textWidthInColumns(this.myEditor, this.myEditor.getDocument().getImmutableCharSequence(), start, end, x);
    }

    @Override
    public int charWidth(char c, int fontType) {
        this.mySharedKey.fontType = fontType;
        this.mySharedKey.c = c;
        return this.charWidth(c);
    }

    @Override
    public int calcSoftWrapUnawareOffset(int startOffset, int endOffset, int startColumn, int column, int startX) {
        return EditorUtil.calcSoftWrapUnawareOffset(this.myEditor, this.myEditor.getDocument().getImmutableCharSequence(), startOffset, endOffset, column, EditorUtil.getTabSize(this.myEditor), startX, new int[]{startColumn}, null);
    }

    @Override
    public int textWidth(int start, int end, int fontType, int x) {
        CharSequence text = this.myEditor.getDocument().getImmutableCharSequence();
        int startToUse = start;
        for (int i = end - 1; i >= start; --i) {
            if (text.charAt(i) != '\n') continue;
            startToUse = i + 1;
            break;
        }
        int result2 = 0;
        this.mySharedKey.fontType = fontType;
        for (int i = startToUse; i < end; ++i) {
            char c = text.charAt(i);
            if (c != '\t') {
                this.mySharedKey.c = c;
                result2 += this.charWidth(c);
                continue;
            }
            result2 += EditorUtil.nextTabStop(x + result2, this.myEditor) - result2 - x;
        }
        return result2;
    }

    private int charWidth(char c) {
        int result2 = this.mySymbolWidthCache.get((Object)this.mySharedKey);
        if (result2 > 0) {
            return result2;
        }
        Key key = this.mySharedKey.clone();
        FontInfo font = ComplementaryFontsRegistry.getFontAbleToDisplay(c, key.fontType, this.myEditor.getColorsScheme().getFontPreferences());
        result2 = font.charWidth(c);
        if (this.mySymbolWidthCache.size() >= 1000) {
            this.mySymbolWidthCache.clear();
        }
        this.mySymbolWidthCache.put((Object)key, result2);
        return result2;
    }

    public void clearSymbolWidthCache() {
        this.mySymbolWidthCache.clear();
    }

    private static class Key {
        @JdkConstants.FontStyle
        private int fontType;
        private char c;

        private Key() {
            this(0, ' ');
        }

        Key(@JdkConstants.FontStyle int fontType, char c) {
            this.fontType = fontType;
            this.c = c;
        }

        protected Key clone() {
            return new Key(this.fontType, this.c);
        }

        public int hashCode() {
            int result2 = this.fontType;
            result2 = 31 * result2 + this.c;
            return result2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (this.fontType != key.fontType) {
                return false;
            }
            return this.c == key.c;
        }
    }
}

