/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.ide.CutProvider;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.PasteProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.util.EditorUIUtil;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.ui.TypingTarget;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.wm.impl.IdeBackgroundUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.Grayer;
import com.intellij.ui.components.Magnificator;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.InputMethodEvent;
import java.awt.im.InputMethodRequests;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleEditableText;
import javax.accessibility.AccessibleExtendedText;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleTextSequence;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class EditorComponentImpl
extends JComponent
implements Scrollable,
DataProvider,
Queryable,
TypingTarget,
Accessible {
    private final EditorImpl myEditor;
    private final ApplicationImpl myApplication;

    public EditorComponentImpl(@NotNull EditorImpl editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/EditorComponentImpl", "<init>"));
        }
        this.myEditor = editor;
        this.enableEvents(2056L);
        this.enableInputMethods(true);
        this.setFocusCycleRoot(true);
        this.setOpaque(true);
        this.putClientProperty(Magnificator.CLIENT_PROPERTY_KEY, new Magnificator(){

            public Point magnify(double scale, Point at) {
                VisualPosition magnificationPosition = EditorComponentImpl.this.myEditor.xyToVisualPosition(at);
                double currentSize = EditorComponentImpl.this.myEditor.getColorsScheme().getEditorFontSize();
                int defaultFontSize = EditorColorsManager.getInstance().getGlobalScheme().getEditorFontSize();
                EditorComponentImpl.this.myEditor.setFontSize(Math.max((int)(currentSize * scale), defaultFontSize));
                return EditorComponentImpl.this.myEditor.visualPositionToXY(magnificationPosition);
            }
        });
        this.myApplication = (ApplicationImpl)ApplicationManager.getApplication();
    }

    @Override
    public void paint(@NotNull Graphics g) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorComponentImpl", "paint"));
        }
        if (!this.isEnabled()) {
            g = new Grayer((Graphics2D)g, EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground());
        }
        super.paint(g);
    }

    @NotNull
    public EditorImpl getEditor() {
        EditorImpl editorImpl = this.myEditor;
        if (editorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorComponentImpl", "getEditor"));
        }
        return editorImpl;
    }

    public Object getData(String dataId) {
        if (this.myEditor.isRendererMode()) {
            return null;
        }
        if (CommonDataKeys.EDITOR.is(dataId)) {
            return this.myEditor.getVirtualFile() == null ? this.myEditor : null;
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return this.myEditor.getDeleteProvider();
        }
        if (PlatformDataKeys.CUT_PROVIDER.is(dataId)) {
            return this.myEditor.getCutProvider();
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this.myEditor.getCopyProvider();
        }
        if (PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
            return this.myEditor.getPasteProvider();
        }
        return null;
    }

    @Override
    public Color getBackground() {
        return this.myEditor.getBackgroundColor();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.myEditor.getPreferredSize();
    }

    protected void fireResized() {
        this.processComponentEvent(new ComponentEvent(this, 101));
    }

    @Override
    protected void processInputMethodEvent(InputMethodEvent e) {
        super.processInputMethodEvent(e);
        if (!e.isConsumed()) {
            switch (e.getID()) {
                case 1100: {
                    this.myEditor.replaceInputMethodText(e);
                }
                case 1101: {
                    this.myEditor.inputMethodCaretPositionChanged(e);
                }
            }
            e.consume();
        }
    }

    public ActionCallback type(final String text) {
        final ActionCallback result2 = new ActionCallback();
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                EditorComponentImpl.this.myEditor.type(text).notify(result2);
            }
        });
        return result2;
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        return IdeEventQueue.getInstance().isInputMethodEnabled() ? this.myEditor.getInputMethodRequests() : null;
    }

    @Override
    public void paintComponent(Graphics g) {
        this.myApplication.editorPaintStart();
        try {
            Graphics2D gg = !Boolean.TRUE.equals(EditorTextField.SUPPLEMENTARY_KEY.get((UserDataHolder)this.myEditor)) ? IdeBackgroundUtil.withEditorBackground(g, this) : (Graphics2D)g;
            UIUtil.setupComposite((Graphics2D)gg);
            EditorUIUtil.setupAntialiasing(gg);
            this.myEditor.paint(gg);
        }
        finally {
            this.myApplication.editorPaintFinish();
        }
    }

    @Override
    public void revalidate() {
        this.myEditor.resetPaintersWidth();
        super.revalidate();
    }

    public void repaintEditorComponent() {
        this.repaint();
    }

    public void repaintEditorComponent(int x, int y, int width, int height) {
        this.repaint(x, y, width, height);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.myEditor.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            return this.myEditor.getLineHeight();
        }
        return EditorUtil.getSpaceWidth(0, this.myEditor);
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            int lineHeight = this.myEditor.getLineHeight();
            if (direction > 0) {
                int lineNumber = (visibleRect.y + visibleRect.height) / lineHeight;
                return lineHeight * lineNumber - visibleRect.y;
            }
            int lineNumber = (visibleRect.y - visibleRect.height) / lineHeight;
            return visibleRect.y - lineHeight * lineNumber;
        }
        return visibleRect.width;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return this.getParent() instanceof JViewport && this.getParent().getWidth() > this.getPreferredSize().width;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return this.getParent() instanceof JViewport && this.getParent().getHeight() > this.getPreferredSize().height;
    }

    public void putInfo(@NotNull Map<String, String> info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/editor/impl/EditorComponentImpl", "putInfo"));
        }
        this.myEditor.putInfo(info);
    }

    @Override
    @NonNls
    public String toString() {
        return "EditorComponent file=" + this.myEditor.getVirtualFile();
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null && !this.myEditor.isDisposed()) {
            this.accessibleContext = new AccessibleEditor();
        }
        return this.accessibleContext;
    }

    protected class AccessibleEditor
    extends JComponent.AccessibleJComponent
    implements AccessibleText,
    AccessibleAction,
    AccessibleEditableText,
    AccessibleExtendedText,
    CaretListener,
    DocumentListener {
        int caretPos;
        Point oldLocationOnScreen;

        public AccessibleEditor() {
            super(EditorComponentImpl.this);
            EditorComponentImpl.this.getEditor().getDocument().addDocumentListener(this, EditorComponentImpl.this.myEditor.getDisposable());
            EditorComponentImpl.this.getEditor().getCaretModel().addCaretListener(this);
            this.caretPos = this.getCaretPosition();
            try {
                this.oldLocationOnScreen = this.getLocationOnScreen();
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
            EditorComponentImpl.this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentMoved(ComponentEvent e) {
                    try {
                        Point newLocationOnScreen = AccessibleEditor.this.getLocationOnScreen();
                        AccessibleEditor.this.firePropertyChange("AccessibleVisibleData", AccessibleEditor.this.oldLocationOnScreen, newLocationOnScreen);
                        AccessibleEditor.this.oldLocationOnScreen = newLocationOnScreen;
                    }
                    catch (IllegalComponentStateException illegalComponentStateException) {
                        // empty catch block
                    }
                }
            });
        }

        public void caretUpdate(CaretEvent e) {
        }

        public void insertUpdate(javax.swing.event.DocumentEvent e) {
            this.documentUpdated(e.getOffset());
        }

        protected void documentUpdated(int index) {
            final Integer offset = new Integer(index);
            if (SwingUtilities.isEventDispatchThread()) {
                this.firePropertyChange("AccessibleText", null, offset);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AccessibleEditor.this.firePropertyChange("AccessibleText", null, offset);
                    }
                });
            }
        }

        public void removeUpdate(javax.swing.event.DocumentEvent e) {
            this.documentUpdated(e.getOffset());
        }

        public void changedUpdate(javax.swing.event.DocumentEvent e) {
            this.documentUpdated(e.getOffset());
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet states = super.getAccessibleStateSet();
            if (!EditorComponentImpl.this.getEditor().isViewer()) {
                states.add(AccessibleState.EDITABLE);
            }
            if (!EditorComponentImpl.this.getEditor().isOneLineMode()) {
                states.add(AccessibleState.MULTI_LINE);
            }
            return states;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TEXT;
        }

        @Override
        public AccessibleText getAccessibleText() {
            return this;
        }

        @Override
        public int getIndexAtPoint(Point p) {
            if (p == null) {
                return -1;
            }
            EditorImpl editor = EditorComponentImpl.this.getEditor();
            return editor.logicalPositionToOffset(editor.xyToLogicalPosition(p));
        }

        @Override
        public Rectangle getCharacterBounds(int i) {
            EditorImpl editor = EditorComponentImpl.this.getEditor();
            Point point = editor.offsetToXY(i, true);
            int width = editor.getFontMetrics(0).charWidth(editor.getDocument().getText().charAt(i));
            return new Rectangle(point, new Dimension(width, editor.getLineHeight()));
        }

        @Override
        public int getCharCount() {
            return EditorComponentImpl.this.getEditor().getDocument().getTextLength();
        }

        @Override
        public int getCaretPosition() {
            return EditorComponentImpl.this.getEditor().getCaretModel().getOffset();
        }

        @Override
        public AttributeSet getCharacterAttribute(int i) {
            return null;
        }

        @Override
        public int getSelectionStart() {
            return EditorComponentImpl.this.getEditor().getSelectionModel().getSelectionStart();
        }

        @Override
        public int getSelectionEnd() {
            return EditorComponentImpl.this.getEditor().getSelectionModel().getSelectionEnd();
        }

        @Override
        public String getSelectedText() {
            return EditorComponentImpl.this.getEditor().getSelectionModel().getSelectedText();
        }

        public void caretPositionChanged(CaretEvent e) {
            this.caretUpdate(e);
        }

        public void caretAdded(CaretEvent e) {
            this.caretUpdate(e);
        }

        public void caretRemoved(CaretEvent e) {
            this.caretUpdate(e);
        }

        public void beforeDocumentChange(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            this.documentUpdated(event.getOffset());
        }

        @Override
        public String getAtIndex(int part, int index) {
            return this.getAtIndex(part, index, 0);
        }

        @Override
        public String getAfterIndex(int part, int index) {
            return this.getAtIndex(part, index, 1);
        }

        @Override
        public String getBeforeIndex(int part, int index) {
            return this.getAtIndex(part, index, -1);
        }

        private String getAtIndex(int part, int index, int direction) {
            return "?";
        }

        @Override
        public AccessibleEditableText getAccessibleEditableText() {
            return this;
        }

        @Override
        public void setTextContents(String s) {
            EditorComponentImpl.this.getEditor().getDocument().setText(s);
        }

        @Override
        public void insertTextAtIndex(int index, String s) {
            EditorComponentImpl.this.getEditor().getDocument().insertString(index, s);
        }

        @Override
        public String getTextRange(int startIndex, int endIndex) {
            return EditorComponentImpl.this.getEditor().getDocument().getText(TextRange.create((int)startIndex, (int)endIndex));
        }

        @Override
        public void delete(int startIndex, int endIndex) {
            if (!EditorComponentImpl.this.getEditor().isViewer()) {
                EditorComponentImpl.this.getEditor().getDocument().deleteString(startIndex, endIndex);
            } else {
                UIManager.getLookAndFeel().provideErrorFeedback(EditorComponentImpl.this);
            }
        }

        @Override
        public void cut(int startIndex, int endIndex) {
            this.selectText(startIndex, endIndex);
            DataContext context = DataManager.getInstance().getDataContext((Component)EditorComponentImpl.this);
            CutProvider cutProvider = EditorComponentImpl.this.getEditor().getCutProvider();
            if (cutProvider.isCutEnabled(context)) {
                cutProvider.performCut(context);
            }
        }

        @Override
        public void paste(int startIndex) {
            EditorComponentImpl.this.getEditor().getCaretModel().moveToOffset(startIndex);
            PasteProvider pasteProvider = EditorComponentImpl.this.getEditor().getPasteProvider();
            DataContext context = DataManager.getInstance().getDataContext((Component)EditorComponentImpl.this);
            if (pasteProvider.isPasteEnabled(context)) {
                pasteProvider.performPaste(context);
            }
        }

        @Override
        public void replaceText(int startIndex, int endIndex, String s) {
            EditorComponentImpl.this.getEditor().getDocument().replaceString(startIndex, endIndex, s);
        }

        @Override
        public void selectText(int startIndex, int endIndex) {
            EditorComponentImpl.this.getEditor().getSelectionModel().setSelection(startIndex, endIndex);
        }

        @Override
        public void setAttributes(int startIndex, int endIndex, AttributeSet as) {
        }

        private AccessibleTextSequence getSequenceAtIndex(int part, int index, int direction) {
            return null;
        }

        @Override
        public AccessibleTextSequence getTextSequenceAt(int part, int index) {
            return this.getSequenceAtIndex(part, index, 0);
        }

        @Override
        public AccessibleTextSequence getTextSequenceAfter(int part, int index) {
            return this.getSequenceAtIndex(part, index, 1);
        }

        @Override
        public AccessibleTextSequence getTextSequenceBefore(int part, int index) {
            return this.getSequenceAtIndex(part, index, -1);
        }

        @Override
        public Rectangle getTextBounds(int startIndex, int endIndex) {
            Point start = EditorComponentImpl.this.getEditor().offsetToXY(startIndex, true);
            Point end = EditorComponentImpl.this.getEditor().offsetToXY(endIndex, true);
            if (start.y == end.y) {
                return new Rectangle(start, new Dimension(end.x - start.x, EditorComponentImpl.this.getEditor().getLineHeight()));
            }
            int width = EditorComponentImpl.this.getEditor().getMaxWidthInRange(startIndex, endIndex);
            return new Rectangle(start, new Dimension(width, end.y - start.y + EditorComponentImpl.this.getEditor().getLineHeight()));
        }

        @Override
        public AccessibleAction getAccessibleAction() {
            return this;
        }

        @Override
        public int getAccessibleActionCount() {
            return 0;
        }

        @Override
        public String getAccessibleActionDescription(int i) {
            return null;
        }

        @Override
        public boolean doAccessibleAction(int i) {
            return false;
        }
    }
}

