/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForcedSoftWrapsNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel>
implements DumbAware {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"forced.soft.wraps.notification.panel");
    private static final String DISABLED_NOTIFICATION_KEY = "disable.forced.soft.wraps.notification";

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/ForcedSoftWrapsNotificationProvider", "getKey"));
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(final @NotNull VirtualFile file2, @NotNull FileEditor fileEditor) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/editor/impl/ForcedSoftWrapsNotificationProvider", "createNotificationPanel"));
        }
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "com/intellij/openapi/editor/impl/ForcedSoftWrapsNotificationProvider", "createNotificationPanel"));
        }
        if (!(fileEditor instanceof TextEditor)) {
            return null;
        }
        final Editor editor = ((TextEditor)fileEditor).getEditor();
        final Project project = editor.getProject();
        if (project == null || !Boolean.TRUE.equals(editor.getUserData(EditorImpl.FORCED_SOFT_WRAPS)) || PropertiesComponent.getInstance().isTrueValue(DISABLED_NOTIFICATION_KEY)) {
            return null;
        }
        EditorNotificationPanel panel = new EditorNotificationPanel();
        panel.setText(EditorBundle.message((String)"forced.soft.wrap.message", (Object[])new Object[0]));
        panel.createActionLabel(EditorBundle.message((String)"forced.soft.wrap.hide.message", (Object[])new Object[0]), new Runnable(){

            @Override
            public void run() {
                editor.putUserData(EditorImpl.FORCED_SOFT_WRAPS, null);
                EditorNotifications.getInstance((Project)project).updateNotifications(file2);
            }
        });
        panel.createActionLabel(EditorBundle.message((String)"forced.soft.wrap.dont.show.again.message", (Object[])new Object[0]), new Runnable(){

            @Override
            public void run() {
                PropertiesComponent.getInstance().setValue(ForcedSoftWrapsNotificationProvider.DISABLED_NOTIFICATION_KEY, "true");
                EditorNotifications.getInstance((Project)project).updateAllNotifications();
            }
        });
        return panel;
    }
}

