/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import gnu.trove.TDoubleArrayList;

class SummaryStatistics {
    private int myCount;
    private double myMin = Double.MAX_VALUE;
    private double myMax;
    private double myMean;
    private double myS;
    private final TDoubleArrayList values = new TDoubleArrayList();

    SummaryStatistics() {
    }

    void accept(double value) {
        this.values.add(value);
        ++this.myCount;
        this.myMin = Math.min(this.myMin, value);
        this.myMax = Math.max(this.myMax, value);
        if (this.myCount == 1) {
            this.myMean = value;
        } else {
            double previousMean = this.myMean;
            this.myMean += (value - this.myMean) / (double)this.myCount;
            this.myS += (value - previousMean) * (value - this.myMean);
        }
    }

    double getMin() {
        return (this.myMin == Double.MAX_VALUE ? 0.0 : this.myMin) / 1000000.0;
    }

    double getMax() {
        return this.myMax / 1000000.0;
    }

    double getMean() {
        return this.myMean / 1000000.0;
    }

    double getStandardDeviation() {
        return Math.sqrt(this.myS / (double)(this.myCount - 1)) / 1000000.0;
    }

    public String stat() {
        this.values.sort();
        double median = this.values.get(this.values.size() / 2) / 1000000.0;
        return String.format("typing delay, ms: min: %5.1f | max: %5.1f | avg: %5.1f | median: %4.1f", this.getMin(), this.getMax(), this.getMean(), median);
    }
}

