/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.notification;

import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationExtension;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.callback.OpenProjectJdkSettingsCallback;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemNotificationExtensionImpl
implements ExternalSystemNotificationExtension {
    @Override
    @NotNull
    public ProjectSystemId getTargetExternalSystemId() {
        ProjectSystemId projectSystemId = ProjectSystemId.IDE;
        if (projectSystemId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/notification/ExternalSystemNotificationExtensionImpl", "getTargetExternalSystemId"));
        }
        return projectSystemId;
    }

    @Override
    public void customize(@NotNull NotificationData notification, @NotNull Project project, @Nullable Throwable error) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/openapi/externalSystem/service/notification/ExternalSystemNotificationExtensionImpl", "customize"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/notification/ExternalSystemNotificationExtensionImpl", "customize"));
        }
        if (error == null) {
            return;
        }
        Throwable unwrapped = RemoteUtil.unwrap((Throwable)error);
        if (unwrapped instanceof ExternalSystemException) {
            ExternalSystemNotificationExtensionImpl.updateNotification(notification, project, (ExternalSystemException)unwrapped);
        }
    }

    private static void updateNotification(@NotNull NotificationData notificationData, @NotNull Project project, @NotNull ExternalSystemException e) {
        if (notificationData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notificationData", "com/intellij/openapi/externalSystem/service/notification/ExternalSystemNotificationExtensionImpl", "updateNotification"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/notification/ExternalSystemNotificationExtensionImpl", "updateNotification"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/externalSystem/service/notification/ExternalSystemNotificationExtensionImpl", "updateNotification"));
        }
        for (String fix : e.getQuickFixes()) {
            if (!"#open_project_jdk_settings".equals(fix)) continue;
            notificationData.setListener("#open_project_jdk_settings", (NotificationListener)new OpenProjectJdkSettingsCallback(project));
        }
    }
}

