/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.autoimport;

import com.intellij.openapi.externalSystem.ExternalSystemAutoImportAware;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachingExternalSystemAutoImportAware
implements ExternalSystemAutoImportAware {
    @NotNull
    private final ConcurrentMap<String, String> myCache;
    @NotNull
    private final ExternalSystemAutoImportAware myDelegate;

    public CachingExternalSystemAutoImportAware(@NotNull ExternalSystemAutoImportAware delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/openapi/externalSystem/service/project/autoimport/CachingExternalSystemAutoImportAware", "<init>"));
        }
        this.myCache = ContainerUtil.newConcurrentMap();
        this.myDelegate = delegate;
    }

    @Nullable
    public String getAffectedExternalProjectPath(@NotNull String changedFileOrDirPath, @NotNull Project project) {
        if (changedFileOrDirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedFileOrDirPath", "com/intellij/openapi/externalSystem/service/project/autoimport/CachingExternalSystemAutoImportAware", "getAffectedExternalProjectPath"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/autoimport/CachingExternalSystemAutoImportAware", "getAffectedExternalProjectPath"));
        }
        String cached = (String)this.myCache.get(changedFileOrDirPath);
        if (cached != null) {
            return cached;
        }
        String result2 = this.myDelegate.getAffectedExternalProjectPath(changedFileOrDirPath, project);
        if (result2 != null) {
            this.myCache.put(changedFileOrDirPath, result2);
        }
        return result2;
    }
}

