/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsDataStorage;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsState;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemKeymapExtension;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemRunManagerListener;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemShortcutsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemTaskActivator;
import com.intellij.openapi.externalSystem.service.project.manage.TaskActivationState;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalProjectsViewImpl;
import com.intellij.openapi.externalSystem.view.ExternalProjectsViewState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ExternalProjectsManager", storages={@Storage(file="$WORKSPACE_FILE$")})
public class ExternalProjectsManager
implements PersistentStateComponent<ExternalProjectsState>,
Disposable {
    private static final Logger LOG = Logger.getInstance(ExternalProjectsManager.class);
    private final AtomicBoolean isInitialized;
    @NotNull
    private ExternalProjectsState myState;
    @NotNull
    private final Project myProject;
    private final ExternalSystemRunManagerListener myRunManagerListener;
    private final ExternalSystemTaskActivator myTaskActivator;
    private final ExternalSystemShortcutsManager myShortcutsManager;
    private final List<ExternalProjectsView> myProjectsViews;

    public static ExternalProjectsManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsManager", "getInstance"));
        }
        return (ExternalProjectsManager)ServiceManager.getService((Project)project, ExternalProjectsManager.class);
    }

    public ExternalProjectsManager(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsManager", "<init>"));
        }
        this.isInitialized = new AtomicBoolean();
        this.myState = new ExternalProjectsState();
        this.myProjectsViews = new SmartList();
        this.myProject = project;
        Disposer.register((Disposable)project, (Disposable)this);
        this.myShortcutsManager = new ExternalSystemShortcutsManager(project);
        Disposer.register((Disposable)this, (Disposable)this.myShortcutsManager);
        this.myTaskActivator = new ExternalSystemTaskActivator(project);
        this.myRunManagerListener = new ExternalSystemRunManagerListener(this);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsManager", "getProject"));
        }
        return project;
    }

    public ExternalSystemShortcutsManager getShortcutsManager() {
        return this.myShortcutsManager;
    }

    public ExternalSystemTaskActivator getTaskActivator() {
        return this.myTaskActivator;
    }

    public void registerView(@NotNull ExternalProjectsView externalProjectsView) {
        if (externalProjectsView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalProjectsView", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsManager", "registerView"));
        }
        assert (this.getExternalProjectsView(externalProjectsView.getSystemId()) == null);
        this.init();
        this.myProjectsViews.add(externalProjectsView);
        if (externalProjectsView instanceof ExternalProjectsViewImpl) {
            ExternalProjectsViewImpl view = (ExternalProjectsViewImpl)externalProjectsView;
            view.loadState(this.myState.getExternalSystemsState().get(externalProjectsView.getSystemId().getId()).getProjectsViewState());
            view.init();
        }
    }

    @Nullable
    public ExternalProjectsView getExternalProjectsView(@NotNull ProjectSystemId systemId) {
        if (systemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "systemId", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsManager", "getExternalProjectsView"));
        }
        for (ExternalProjectsView projectsView : this.myProjectsViews) {
            if (!projectsView.getSystemId().equals((Object)systemId)) continue;
            return projectsView;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        AtomicBoolean atomicBoolean = this.isInitialized;
        synchronized (atomicBoolean) {
            if (this.isInitialized.getAndSet(true)) {
                return;
            }
            ExternalProjectsDataStorage.getInstance(this.myProject).load();
            this.myRunManagerListener.attach();
            this.myShortcutsManager.init();
            for (ExternalSystemManager systemManager : ExternalSystemApiUtil.getAllManagers()) {
                Collection<ExternalProjectInfo> externalProjects = ExternalProjectsDataStorage.getInstance(this.myProject).list(systemManager.getSystemId());
                for (ExternalProjectInfo externalProject : externalProjects) {
                    if (externalProject.getExternalProjectStructure() == null) continue;
                    Collection taskData = ExternalSystemApiUtil.findAllRecursively((DataNode)externalProject.getExternalProjectStructure(), (Key)ProjectKeys.TASK);
                    this.myShortcutsManager.scheduleKeymapUpdate(taskData);
                }
                if (externalProjects.isEmpty()) continue;
                this.myShortcutsManager.scheduleRunConfigurationKeymapUpdate(systemManager.getSystemId());
            }
            this.myTaskActivator.init();
        }
    }

    public void updateExternalProjectData(ExternalProjectInfo externalProject) {
        ExternalProjectsDataStorage.getInstance(this.myProject).update(externalProject);
        if (externalProject.getExternalProjectStructure() != null) {
            ProjectData projectData = (ProjectData)externalProject.getExternalProjectStructure().getData();
            ExternalSystemUtil.scheduleExternalViewStructureUpdate(this.myProject, projectData.getOwner());
            Collection taskData = ExternalSystemApiUtil.findAllRecursively((DataNode)externalProject.getExternalProjectStructure(), (Key)ProjectKeys.TASK);
            this.myShortcutsManager.scheduleKeymapUpdate(taskData);
            this.myShortcutsManager.scheduleRunConfigurationKeymapUpdate(projectData.getOwner());
        }
    }

    public void forgetExternalProjectData(@NotNull ProjectSystemId projectSystemId, @NotNull String linkedProjectPath) {
        if (projectSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectSystemId", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsManager", "forgetExternalProjectData"));
        }
        if (linkedProjectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linkedProjectPath", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsManager", "forgetExternalProjectData"));
        }
        ExternalProjectsDataStorage.getInstance(this.myProject).remove(projectSystemId, linkedProjectPath);
        ExternalSystemUtil.scheduleExternalViewStructureUpdate(this.myProject, projectSystemId);
    }

    @NotNull
    public ExternalProjectsState getState() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        for (ExternalProjectsView externalProjectsView : this.myProjectsViews) {
            if (!(externalProjectsView instanceof ExternalProjectsViewImpl)) continue;
            ExternalProjectsViewState externalProjectsViewState = ((ExternalProjectsViewImpl)externalProjectsView).getState();
            ExternalProjectsState.State state = this.myState.getExternalSystemsState().get(externalProjectsView.getSystemId().getId());
            assert (state != null);
            state.setProjectsViewState(externalProjectsViewState);
        }
        ExternalProjectsState externalProjectsState = this.myState;
        if (externalProjectsState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsManager", "getState"));
        }
        return externalProjectsState;
    }

    @NotNull
    public ExternalProjectsStateProvider getStateProvider() {
        ExternalProjectsStateProvider externalProjectsStateProvider = new ExternalProjectsStateProvider(){

            @Override
            public List<ExternalProjectsStateProvider.TasksActivation> getAllTasksActivation() {
                SmartList result2 = new SmartList();
                for (Map.Entry<String, ExternalProjectsState.State> systemState : ExternalProjectsManager.this.myState.getExternalSystemsState().entrySet()) {
                    ProjectSystemId systemId = new ProjectSystemId(systemState.getKey());
                    for (Map.Entry<String, TaskActivationState> activationStateEntry : systemState.getValue().getExternalSystemsTaskActivation().entrySet()) {
                        result2.add(new ExternalProjectsStateProvider.TasksActivation(systemId, activationStateEntry.getKey(), activationStateEntry.getValue()));
                    }
                }
                return result2;
            }

            @Override
            public List<ExternalProjectsStateProvider.TasksActivation> getTasksActivation(final @NotNull ProjectSystemId systemId) {
                if (systemId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "systemId", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsManager$1", "getTasksActivation"));
                }
                Set<Map.Entry<String, TaskActivationState>> entries = ExternalProjectsManager.this.myState.getExternalSystemsState().get(systemId.getId()).getExternalSystemsTaskActivation().entrySet();
                return ContainerUtil.map(entries, (Function)new Function<Map.Entry<String, TaskActivationState>, ExternalProjectsStateProvider.TasksActivation>(){

                    public ExternalProjectsStateProvider.TasksActivation fun(Map.Entry<String, TaskActivationState> entry) {
                        return new ExternalProjectsStateProvider.TasksActivation(systemId, entry.getKey(), entry.getValue());
                    }
                });
            }

            @Override
            public TaskActivationState getTasksActivation(@NotNull ProjectSystemId systemId, @NotNull String projectPath) {
                if (systemId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "systemId", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsManager$1", "getTasksActivation"));
                }
                if (projectPath == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectPath", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsManager$1", "getTasksActivation"));
                }
                return ExternalProjectsManager.this.myState.getExternalSystemsState().get(systemId.getId()).getExternalSystemsTaskActivation().get(projectPath);
            }

            @Override
            public Map<String, TaskActivationState> getProjectsTasksActivationMap(@NotNull ProjectSystemId systemId) {
                if (systemId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "systemId", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsManager$1", "getProjectsTasksActivationMap"));
                }
                return ExternalProjectsManager.this.myState.getExternalSystemsState().get(systemId.getId()).getExternalSystemsTaskActivation();
            }
        };
        if (externalProjectsStateProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsManager", "getStateProvider"));
        }
        return externalProjectsStateProvider;
    }

    public boolean isIgnored(@NotNull ProjectSystemId systemId, @NotNull String projectPath) {
        if (systemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "systemId", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsManager", "isIgnored"));
        }
        if (projectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectPath", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsManager", "isIgnored"));
        }
        ExternalProjectInfo projectInfo = ExternalSystemUtil.getExternalProjectInfo(this.myProject, systemId, projectPath);
        if (projectInfo == null) {
            return true;
        }
        return ExternalProjectsDataStorage.getInstance(this.myProject).isIgnored(projectInfo.getExternalProjectPath(), projectPath, ProjectKeys.MODULE);
    }

    public void setIgnored(@NotNull DataNode<?> dataNode, boolean isIgnored) {
        if (dataNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataNode", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsManager", "setIgnored"));
        }
        ExternalProjectsDataStorage.getInstance(this.myProject).setIgnored(dataNode, isIgnored);
        ExternalSystemKeymapExtension.updateActions(this.myProject, ExternalSystemApiUtil.findAllRecursively(dataNode, (Key)ProjectKeys.TASK));
    }

    public void loadState(ExternalProjectsState state) {
        this.myState = state == null ? new ExternalProjectsState() : state;
    }

    public void dispose() {
        this.myProjectsViews.clear();
        this.myRunManagerListener.detach();
    }

    public static interface ExternalProjectsStateProvider {
        public List<TasksActivation> getAllTasksActivation();

        public List<TasksActivation> getTasksActivation(@NotNull ProjectSystemId var1);

        public TaskActivationState getTasksActivation(@NotNull ProjectSystemId var1, @NotNull String var2);

        public Map<String, TaskActivationState> getProjectsTasksActivationMap(@NotNull ProjectSystemId var1);

        public static class TasksActivation {
            public final ProjectSystemId systemId;
            public final String projectPath;
            public final TaskActivationState state;

            public TasksActivation(ProjectSystemId systemId, String projectPath, TaskActivationState state) {
                this.systemId = systemId;
                this.projectPath = projectPath;
                this.state = state;
            }
        }
    }
}

