/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.remote;

import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.RemoteExternalSystemService;
import com.intellij.util.Producer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRemoteExternalSystemService<S extends ExternalSystemExecutionSettings>
implements RemoteExternalSystemService<S> {
    private final ConcurrentMap<ExternalSystemTaskType, Set<ExternalSystemTaskId>> myTasksInProgress = ContainerUtil.newConcurrentMap();
    private final AtomicReference<S> mySettings = new AtomicReference();
    private final AtomicReference<ExternalSystemTaskNotificationListener> myListener = new AtomicReference();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T execute(@NotNull ExternalSystemTaskId id, @NotNull Producer<T> task) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/externalSystem/service/remote/AbstractRemoteExternalSystemService", "execute"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/externalSystem/service/remote/AbstractRemoteExternalSystemService", "execute"));
        }
        Set tasks = (Set)this.myTasksInProgress.get(id.getType());
        if (tasks == null) {
            this.myTasksInProgress.putIfAbsent(id.getType(), (Set<ExternalSystemTaskId>)new HashSet());
            tasks = (Set)this.myTasksInProgress.get(id.getType());
        }
        tasks.add(id);
        try {
            Object object = task.produce();
            return (T)object;
        }
        finally {
            tasks.remove(id);
        }
    }

    @Override
    public void setSettings(@NotNull S settings) throws RemoteException {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/openapi/externalSystem/service/remote/AbstractRemoteExternalSystemService", "setSettings"));
        }
        this.mySettings.set(settings);
    }

    @Nullable
    public S getSettings() {
        return (S)((ExternalSystemExecutionSettings)this.mySettings.get());
    }

    @Override
    public void setNotificationListener(@NotNull ExternalSystemTaskNotificationListener listener) throws RemoteException {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/externalSystem/service/remote/AbstractRemoteExternalSystemService", "setNotificationListener"));
        }
        this.myListener.set(listener);
    }

    @NotNull
    public ExternalSystemTaskNotificationListener getNotificationListener() {
        ExternalSystemTaskNotificationListener externalSystemTaskNotificationListener = this.myListener.get();
        if (externalSystemTaskNotificationListener == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/remote/AbstractRemoteExternalSystemService", "getNotificationListener"));
        }
        return externalSystemTaskNotificationListener;
    }

    @Override
    public boolean isTaskInProgress(@NotNull ExternalSystemTaskId id) throws RemoteException {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/externalSystem/service/remote/AbstractRemoteExternalSystemService", "isTaskInProgress"));
        }
        Set tasks = (Set)this.myTasksInProgress.get(id.getType());
        return tasks != null && tasks.contains(id);
    }

    @Override
    @NotNull
    public Map<ExternalSystemTaskType, Set<ExternalSystemTaskId>> getTasksInProgress() throws RemoteException {
        ConcurrentMap<ExternalSystemTaskType, Set<ExternalSystemTaskId>> concurrentMap = this.myTasksInProgress;
        if (concurrentMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/remote/AbstractRemoteExternalSystemService", "getTasksInProgress"));
        }
        return concurrentMap;
    }
}

