/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl;

import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.impl.DefaultKeymapImpl;
import javax.swing.KeyStroke;
import org.intellij.lang.annotations.JdkConstants;

public class MacOSDefaultKeymap
extends DefaultKeymapImpl {
    @Override
    protected String[] getParentActionIds(KeyStroke firstKeyStroke) {
        return super.getParentActionIds(MacOSDefaultKeymap.convertKeyStroke(firstKeyStroke));
    }

    @Override
    protected String[] getParentActionIds(MouseShortcut shortcut) {
        return super.getParentActionIds(MacOSDefaultKeymap.convertMouseShortcut(shortcut));
    }

    @Override
    protected Shortcut[] getParentShortcuts(String actionId) {
        Shortcut[] parentShortcuts = super.getParentShortcuts(actionId);
        Shortcut[] macShortcuts = new Shortcut[parentShortcuts.length];
        for (int i = 0; i < parentShortcuts.length; ++i) {
            macShortcuts[i] = MacOSDefaultKeymap.convertShortcutFromParent(parentShortcuts[i]);
        }
        return macShortcuts;
    }

    public static Shortcut convertShortcutFromParent(Shortcut parentShortcut) {
        if (parentShortcut instanceof MouseShortcut) {
            return MacOSDefaultKeymap.convertMouseShortcut((MouseShortcut)parentShortcut);
        }
        KeyboardShortcut key = (KeyboardShortcut)parentShortcut;
        return new KeyboardShortcut(MacOSDefaultKeymap.convertKeyStroke(key.getFirstKeyStroke()), MacOSDefaultKeymap.convertKeyStroke(key.getSecondKeyStroke()));
    }

    private static KeyStroke convertKeyStroke(KeyStroke parentKeyStroke) {
        if (parentKeyStroke == null) {
            return null;
        }
        return KeyStroke.getKeyStroke(parentKeyStroke.getKeyCode(), MacOSDefaultKeymap.mapModifiers(parentKeyStroke.getModifiers()), parentKeyStroke.isOnKeyRelease());
    }

    private static MouseShortcut convertMouseShortcut(MouseShortcut macShortcut) {
        return new MouseShortcut(macShortcut.getButton(), MacOSDefaultKeymap.mapModifiers(macShortcut.getModifiers()), macShortcut.getClickCount());
    }

    @JdkConstants.InputEventMask
    private static int mapModifiers(@JdkConstants.InputEventMask int modifiers) {
        boolean meta = false;
        if ((modifiers & 4) != 0) {
            modifiers &= 0xFFFFFFFB;
            meta = true;
        }
        boolean metaDown = false;
        if ((modifiers & 0x100) != 0) {
            modifiers &= 0xFFFFFEFF;
            metaDown = true;
        }
        boolean control = false;
        if ((modifiers & 2) != 0) {
            modifiers &= 0xFFFFFFFD;
            control = true;
        }
        boolean controlDown = false;
        if ((modifiers & 0x80) != 0) {
            modifiers &= 0xFFFFFF7F;
            controlDown = true;
        }
        if (meta) {
            modifiers |= 2;
        }
        if (metaDown) {
            modifiers |= 0x80;
        }
        if (control) {
            modifiers |= 4;
        }
        if (controlDown) {
            modifiers |= 0x100;
        }
        return modifiers;
    }
}

