/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ConfigurationError;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.util.PairProcessor;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import java.awt.EventQueue;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public interface ConfigurationErrors {
    public static final Topic<ConfigurationErrors> TOPIC = Topic.create((String)"Configuration Error", ConfigurationErrors.class, (Topic.BroadcastDirection)Topic.BroadcastDirection.NONE);

    public void addError(@NotNull ConfigurationError var1);

    public void removeError(@NotNull ConfigurationError var1);

    public static class Bus {
        public static void addError(@NotNull ConfigurationError error, @NotNull Project project) {
            if (error == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/intellij/openapi/roots/ui/configuration/ConfigurationErrors$Bus", "addError"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/ui/configuration/ConfigurationErrors$Bus", "addError"));
            }
            Bus._do(error, project, new PairProcessor<ConfigurationErrors, ConfigurationError>(){

                public boolean process(ConfigurationErrors configurationErrors, ConfigurationError configurationError) {
                    configurationErrors.addError(configurationError);
                    return false;
                }
            });
        }

        public static void removeError(@NotNull ConfigurationError error, @NotNull Project project) {
            if (error == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/intellij/openapi/roots/ui/configuration/ConfigurationErrors$Bus", "removeError"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/ui/configuration/ConfigurationErrors$Bus", "removeError"));
            }
            Bus._do(error, project, new PairProcessor<ConfigurationErrors, ConfigurationError>(){

                public boolean process(ConfigurationErrors configurationErrors, ConfigurationError configurationError) {
                    configurationErrors.removeError(configurationError);
                    return false;
                }
            });
        }

        public static void _do(final @NotNull ConfigurationError error, final @NotNull Project project, final @NotNull PairProcessor<ConfigurationErrors, ConfigurationError> fun) {
            if (error == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/intellij/openapi/roots/ui/configuration/ConfigurationErrors$Bus", "_do"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/ui/configuration/ConfigurationErrors$Bus", "_do"));
            }
            if (fun == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun", "com/intellij/openapi/roots/ui/configuration/ConfigurationErrors$Bus", "_do"));
            }
            if (!project.isInitialized()) {
                StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(new Runnable(){

                    @Override
                    public void run() {
                        fun.process(project.getMessageBus().syncPublisher(TOPIC), (Object)error);
                    }
                });
                return;
            }
            final MessageBus bus = project.getMessageBus();
            if (EventQueue.isDispatchThread()) {
                fun.process(bus.syncPublisher(TOPIC), (Object)error);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        fun.process(bus.syncPublisher(TOPIC), (Object)error);
                    }
                });
            }
        }
    }
}

