/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.playback.util;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.util.WindowSystemPlaybackCall;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.Consumer;
import com.intellij.util.messages.MessageBusConnection;
import org.jetbrains.annotations.NotNull;

public class EditorPlaybackCall {
    public static AsyncResult<String> assertEditorLine(PlaybackContext context, final String expected) {
        final AsyncResult result2 = new AsyncResult();
        WindowSystemPlaybackCall.getUiReady(context).doWhenDone(new Runnable(){

            @Override
            public void run() {
                Editor editor = (Editor)CommonDataKeys.EDITOR.getData((DataContext)DataManager.getInstance().getDataContextFromFocus().getResult());
                if (editor == null) {
                    editor = (Editor)CommonDataKeys.EDITOR_EVEN_IF_INACTIVE.getData((DataContext)DataManager.getInstance().getDataContextFromFocus().getResult());
                }
                if (editor == null) {
                    result2.setRejected((Object)"Cannot find editor");
                    return;
                }
                int line = editor.getCaretModel().getLogicalPosition().line;
                int caret = editor.getCaretModel().getOffset();
                int start = editor.getDocument().getLineStartOffset(line);
                int end = editor.getDocument().getLineEndOffset(line);
                StringBuffer actualText = new StringBuffer(editor.getDocument().getText(new TextRange(start, caret)));
                actualText.append("<caret>").append(editor.getDocument().getText(new TextRange(caret, end)));
                if (expected.equals(actualText.toString())) {
                    result2.setDone();
                } else {
                    result2.setRejected((Object)("Expected:" + expected + " but was:" + actualText));
                }
            }
        });
        return result2;
    }

    public static AsyncResult<String> waitDaemonForFinish(final PlaybackContext context) {
        final AsyncResult result2 = new AsyncResult();
        final Disposable connection = Disposer.newDisposable();
        result2.doWhenProcessed(new Runnable(){

            @Override
            public void run() {
                Disposer.dispose((Disposable)connection);
            }
        });
        WindowSystemPlaybackCall.findProject().doWhenDone((Consumer)new Consumer<Project>(){

            public void consume(Project project) {
                MessageBusConnection bus = project.getMessageBus().connect(connection);
                bus.subscribe(DaemonCodeAnalyzer.DAEMON_EVENT_TOPIC, (Object)new DaemonCodeAnalyzer.DaemonListenerAdapter(){

                    public void daemonFinished() {
                        context.flushAwtAndRunInEdt(result2.createSetDoneRunnable());
                    }

                    public void daemonCancelEventOccurred(@NotNull String reason) {
                        if (reason == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/openapi/ui/playback/util/EditorPlaybackCall$4$1", "daemonCancelEventOccurred"));
                        }
                        result2.setDone();
                    }
                });
            }
        }).doWhenRejected(new Runnable(){

            @Override
            public void run() {
                result2.setRejected((Object)"Cannot find project");
            }
        });
        return result2;
    }
}

