/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.openapi.updateSettings.impl.Product;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpdatesInfo {
    private final List<Product> myProducts;

    public UpdatesInfo(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/updateSettings/impl/UpdatesInfo", "<init>"));
        }
        this.myProducts = new ArrayList<Product>();
        for (Element child : element.getChildren()) {
            this.myProducts.add(new Product(child));
        }
    }

    @Nullable
    public Product getProduct(@NotNull String code) {
        if (code == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "code", "com/intellij/openapi/updateSettings/impl/UpdatesInfo", "getProduct"));
        }
        for (Product product : this.myProducts) {
            if (!product.hasCode(code)) continue;
            return product;
        }
        return null;
    }

    public int getProductsCount() {
        return this.myProducts.size();
    }
}

