/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import org.jetbrains.annotations.NotNull;

public class CommitCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        DataContext dataContext;
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/openapi/vcs/CommitCompletionContributor", "fillCompletionVariants"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/vcs/CommitCompletionContributor", "fillCompletionVariants"));
        }
        PsiFile file2 = parameters.getOriginalFile();
        Document document = PsiDocumentManager.getInstance((Project)file2.getProject()).getDocument(file2);
        if (document != null && (dataContext = (DataContext)document.getUserData(CommitMessage.DATA_CONTEXT_KEY)) != null) {
            ChangeList[] lists;
            result2.stopHere();
            if (parameters.getInvocationCount() > 0 && (lists = (ChangeList[])VcsDataKeys.CHANGE_LISTS.getData(dataContext)) != null) {
                String prefix = TextFieldWithAutoCompletionListProvider.getCompletionPrefix(parameters);
                CompletionResultSet insensitive = result2.caseInsensitive().withPrefixMatcher((PrefixMatcher)new CamelHumpMatcher(prefix));
                for (ChangeList list : lists) {
                    for (Change change : list.getChanges()) {
                        ContentRevision revision = change.getAfterRevision() == null ? change.getBeforeRevision() : change.getAfterRevision();
                        if (revision == null) continue;
                        FilePath filePath = revision.getFile();
                        LookupElementBuilder element = LookupElementBuilder.create((String)filePath.getName()).withIcon(filePath.getFileType().getIcon());
                        insensitive.addElement((LookupElement)element);
                    }
                }
            }
        }
    }
}

