/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.util.PathUtil;
import java.io.File;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalFilePath
implements FilePath {
    @NotNull
    private final String myPath;
    private final boolean myIsDirectory;

    public LocalFilePath(@NotNull String path, boolean isDirectory) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vcs/LocalFilePath", "<init>"));
        }
        this.myPath = FileUtil.toCanonicalPath((String)path);
        this.myIsDirectory = isDirectory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalFilePath path = (LocalFilePath)o;
        if (this.myIsDirectory != path.myIsDirectory) {
            return false;
        }
        return FileUtil.PATH_HASHING_STRATEGY.equals((Object)this.myPath, (Object)path.myPath);
    }

    public int hashCode() {
        int result2 = FileUtil.PATH_HASHING_STRATEGY.computeHashCode((Object)this.myPath);
        result2 = 31 * result2 + (this.myIsDirectory ? 1 : 0);
        return result2;
    }

    public void refresh() {
    }

    public void hardRefresh() {
        LocalFileSystem.getInstance().refreshAndFindFileByPath(this.myPath);
    }

    @NotNull
    public String getPath() {
        String string = this.myPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/LocalFilePath", "getPath"));
        }
        return string;
    }

    public boolean isDirectory() {
        return this.myIsDirectory;
    }

    public boolean isUnder(@NotNull FilePath parent, boolean strict) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vcs/LocalFilePath", "isUnder"));
        }
        return FileUtil.isAncestor((String)parent.getPath(), (String)this.getPath(), (boolean)strict);
    }

    @Nullable
    public FilePath getParentPath() {
        String parent = PathUtil.getParentPath((String)this.myPath);
        return parent.isEmpty() ? null : new LocalFilePath(parent, true);
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        return LocalFileSystem.getInstance().findFileByPath(this.myPath);
    }

    @Nullable
    public VirtualFile getVirtualFileParent() {
        FilePath parent = this.getParentPath();
        return parent != null ? parent.getVirtualFile() : null;
    }

    @NotNull
    public File getIOFile() {
        File file2 = new File(this.myPath);
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/LocalFilePath", "getIOFile"));
        }
        return file2;
    }

    @NotNull
    public String getName() {
        String string = PathUtil.getFileName((String)this.myPath);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/LocalFilePath", "getName"));
        }
        return string;
    }

    @NotNull
    public String getPresentableUrl() {
        String string = FileUtil.toSystemDependentName((String)this.myPath);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/LocalFilePath", "getPresentableUrl"));
        }
        return string;
    }

    @Nullable
    public Document getDocument() {
        VirtualFile file2 = this.getVirtualFile();
        if (file2 == null || file2.getFileType().isBinary()) {
            return null;
        }
        return FileDocumentManager.getInstance().getDocument(file2);
    }

    @NotNull
    public Charset getCharset() {
        Charset charset = this.getCharset(null);
        if (charset == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/LocalFilePath", "getCharset"));
        }
        return charset;
    }

    @NotNull
    public Charset getCharset(@Nullable Project project) {
        VirtualFile file2 = this.getVirtualFile();
        String path = this.myPath;
        while (!(file2 != null && file2.isValid() || path.isEmpty())) {
            path = PathUtil.getParentPath((String)path);
            file2 = LocalFileSystem.getInstance().findFileByPath(path);
        }
        if (file2 != null) {
            Charset charset = file2.getCharset();
            if (charset == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/LocalFilePath", "getCharset"));
            }
            return charset;
        }
        EncodingManager e = project == null ? EncodingManager.getInstance() : EncodingProjectManager.getInstance((Project)project);
        Charset charset = e.getDefaultCharset();
        if (charset == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/LocalFilePath", "getCharset"));
        }
        return charset;
    }

    @NotNull
    public FileType getFileType() {
        VirtualFile file2 = this.getVirtualFile();
        FileTypeManager manager = FileTypeManager.getInstance();
        FileType fileType = file2 != null ? manager.getFileTypeByFile(file2) : manager.getFileTypeByFileName(this.getName());
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/LocalFilePath", "getFileType"));
        }
        return fileType;
    }

    @NonNls
    public String toString() {
        return this.myPath + (this.myIsDirectory ? "/" : "");
    }

    public boolean isNonLocal() {
        return false;
    }
}

