/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DescindingFilesFilter {
    private DescindingFilesFilter() {
    }

    @NotNull
    public static FilePath[] filterDescindingFiles(@NotNull FilePath[] roots, Project project) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/openapi/vcs/actions/DescindingFilesFilter", "filterDescindingFiles"));
        }
        LinkedList<FilePath> result2 = new LinkedList<FilePath>();
        ProjectLevelVcsManager manager = ProjectLevelVcsManager.getInstance((Project)project);
        Arrays.sort(roots, FilePathComparator.getInstance());
        HashMap chains = new HashMap();
        for (FilePath root : roots) {
            AbstractVcs vcs = manager.getVcsFor(root);
            if (vcs == null) continue;
            if (vcs.allowsNestedRoots()) {
                result2.add(root);
                continue;
            }
            List chain = (List)chains.get(vcs.getKeyInstanceMethod());
            if (chain == null) {
                LinkedList<FilePath> newList = new LinkedList<FilePath>();
                newList.add(root);
                chains.put(vcs.getKeyInstanceMethod(), newList);
                continue;
            }
            boolean failed = false;
            for (FilePath chainedPath : chain) {
                if (!VfsUtilCore.isAncestor((File)chainedPath.getIOFile(), (File)root.getIOFile(), (boolean)false)) continue;
                failed = true;
                break;
            }
            if (failed) continue;
            chain.add(root);
        }
        for (List filePaths : chains.values()) {
            result2.addAll(filePaths);
        }
        FilePath[] filePathArray = result2.toArray(new FilePath[result2.size()]);
        if (filePathArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/DescindingFilesFilter", "filterDescindingFiles"));
        }
        return filePathArray;
    }

    private static class FilePathComparator
    implements Comparator<FilePath> {
        private static final FilePathComparator ourInstance = new FilePathComparator();

        private FilePathComparator() {
        }

        public static FilePathComparator getInstance() {
            return ourInstance;
        }

        @Override
        public int compare(FilePath fp1, FilePath fp2) {
            return fp1.getIOFile().getAbsolutePath().length() - fp2.getIOFile().getAbsolutePath().length();
        }
    }
}

