/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import java.util.Iterator;

public class SplittingIterator
implements Iterator<Integer> {
    private final String myContents;
    private int myOffset;

    public SplittingIterator(String contents) {
        this.myContents = contents;
        this.myOffset = 0;
    }

    @Override
    public boolean hasNext() {
        return this.myOffset < this.myContents.length();
    }

    @Override
    public Integer next() {
        int start = this.myOffset;
        while (this.myOffset < this.myContents.length()) {
            char c = this.myContents.charAt(this.myOffset);
            if ('\n' == c) {
                ++this.myOffset;
                break;
            }
            if ('\r' == c) {
                if (this.myOffset + 1 == this.myContents.length()) {
                    ++this.myOffset;
                    break;
                }
                this.myOffset += '\n' == this.myContents.charAt(this.myOffset + 1) ? 2 : 1;
                break;
            }
            ++this.myOffset;
        }
        return start;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

