/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.ChangesBrowserSettingsEditor;
import com.intellij.ui.JBColor;
import com.intellij.util.Alarm;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class CommittedChangesFilterDialog
extends DialogWrapper {
    private final ChangesBrowserSettingsEditor myPanel;
    private ChangeBrowserSettings mySettings;
    private final JLabel myErrorLabel = new JLabel();
    private final Alarm myValidateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    private final Runnable myValidateRunnable = new Runnable(){

        @Override
        public void run() {
            CommittedChangesFilterDialog.this.validateInput();
            CommittedChangesFilterDialog.this.myValidateAlarm.addRequest(CommittedChangesFilterDialog.this.myValidateRunnable, 500, ModalityState.stateForComponent((Component)CommittedChangesFilterDialog.this.myPanel.getComponent()));
        }
    };

    public CommittedChangesFilterDialog(Project project, ChangesBrowserSettingsEditor panel, ChangeBrowserSettings settings) {
        super(project, false);
        this.myPanel = panel;
        this.myPanel.setSettings(settings);
        this.setTitle(VcsBundle.message((String)"browse.changes.filter.title", (Object[])new Object[0]));
        this.init();
        this.myErrorLabel.setForeground((Color)JBColor.RED);
        this.validateInput();
        this.myValidateAlarm.addRequest(this.myValidateRunnable, 500, ModalityState.stateForComponent((Component)this.myPanel.getComponent()));
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.myPanel.getComponent(), "Center");
        panel.add((Component)this.myErrorLabel, "South");
        return panel;
    }

    private void validateInput() {
        String error = this.myPanel.validateInput();
        this.setOKActionEnabled(error == null);
        this.myErrorLabel.setText(error == null ? " " : error);
    }

    protected void doOKAction() {
        this.validateInput();
        if (this.isOKActionEnabled()) {
            this.myValidateAlarm.cancelAllRequests();
            this.mySettings = this.myPanel.getSettings();
            super.doOKAction();
        }
    }

    public ChangeBrowserSettings getSettings() {
        return this.mySettings;
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "AbstractVcsHelper.FilterDialog." + this.myPanel.getDimensionServiceKey();
    }
}

