/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ChangeListColumn;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.committed.ChangeListFilteringStrategy;
import com.intellij.openapi.vcs.changes.committed.ColumnFilteringStrategy;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesFilterKey;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vcs.changes.committed.LabeledComboBoxAction;
import com.intellij.openapi.vcs.changes.committed.StructureFilteringStrategy;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;

public class SelectFilteringAction
extends LabeledComboBoxAction {
    private final Project myProject;
    private final CommittedChangesTreeBrowser myBrowser;
    private CommittedChangesFilterKey myPreviousSelection;

    public SelectFilteringAction(Project project, CommittedChangesTreeBrowser browser) {
        super(VcsBundle.message((String)"committed.changes.filter.title", (Object[])new Object[0]));
        this.myProject = project;
        this.myBrowser = browser;
        this.myPreviousSelection = null;
    }

    @Override
    protected ComboBoxModel createModel() {
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(new Object[]{ChangeListFilteringStrategy.NONE, new StructureFilteringStrategy(this.myProject)});
        AbstractVcs[] vcss = ProjectLevelVcsManager.getInstance((Project)this.myProject).getAllActiveVcss();
        boolean addNameFilter = false;
        for (AbstractVcs vcs : vcss) {
            CommittedChangesProvider provider = vcs.getCommittedChangesProvider();
            if (provider == null) continue;
            addNameFilter = true;
            for (ChangeListColumn column : provider.getColumns()) {
                if (!ChangeListColumn.isCustom((ChangeListColumn)column)) continue;
                model.addElement(new ColumnFilteringStrategy(column, provider.getClass()));
            }
        }
        if (addNameFilter) {
            model.addElement(new ColumnFilteringStrategy(ChangeListColumn.NAME, CommittedChangesProvider.class));
        }
        return model;
    }

    @Override
    protected void selectionChanged(Object selection) {
        if (selection == null) {
            return;
        }
        if (this.myPreviousSelection != null) {
            this.myBrowser.removeFilteringStrategy(this.myPreviousSelection);
        }
        ChangeListFilteringStrategy strategy = (ChangeListFilteringStrategy)selection;
        if (!ChangeListFilteringStrategy.NONE.equals(selection)) {
            this.myBrowser.setFilteringStrategy(strategy);
        }
        this.myPreviousSelection = strategy.getKey();
    }
}

