/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CheckinHandlerUtil;
import com.intellij.openapi.vcs.checkin.CheckinMetaHandler;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.ui.NonFocusableCheckBox;
import java.awt.GridLayout;
import java.util.Collection;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReformatBeforeCheckinHandler
extends CheckinHandler
implements CheckinMetaHandler {
    protected final Project myProject;
    private final CheckinProjectPanel myPanel;

    public ReformatBeforeCheckinHandler(Project project, CheckinProjectPanel panel) {
        this.myProject = project;
        this.myPanel = panel;
    }

    @Nullable
    public RefreshableOnComponent getBeforeCheckinConfigurationPanel() {
        NonFocusableCheckBox reformatBox = new NonFocusableCheckBox(VcsBundle.message((String)"checkbox.checkin.options.reformat.code", (Object[])new Object[0]));
        return new RefreshableOnComponent((JCheckBox)reformatBox){
            final /* synthetic */ JCheckBox val$reformatBox;
            {
                this.val$reformatBox = jCheckBox;
            }

            public JComponent getComponent() {
                JPanel panel = new JPanel(new GridLayout(1, 0));
                panel.add(this.val$reformatBox);
                return panel;
            }

            public void refresh() {
            }

            public void saveState() {
                ReformatBeforeCheckinHandler.this.getSettings().REFORMAT_BEFORE_PROJECT_COMMIT = this.val$reformatBox.isSelected();
            }

            public void restoreState() {
                this.val$reformatBox.setSelected(ReformatBeforeCheckinHandler.this.getSettings().REFORMAT_BEFORE_PROJECT_COMMIT);
            }
        };
    }

    protected VcsConfiguration getSettings() {
        return VcsConfiguration.getInstance((Project)this.myProject);
    }

    public void runCheckinHandlers(final @NotNull Runnable finishAction) {
        if (finishAction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finishAction", "com/intellij/openapi/vcs/checkin/ReformatBeforeCheckinHandler", "runCheckinHandlers"));
        }
        VcsConfiguration configuration = VcsConfiguration.getInstance((Project)this.myProject);
        Collection files = this.myPanel.getVirtualFiles();
        Runnable performCheckoutAction = new Runnable(){

            @Override
            public void run() {
                FileDocumentManager.getInstance().saveAllDocuments();
                finishAction.run();
            }
        };
        if (ReformatBeforeCheckinHandler.reformat(configuration, true)) {
            new ReformatCodeProcessor(this.myProject, CheckinHandlerUtil.getPsiFiles(this.myProject, files), FormatterUtil.REFORMAT_BEFORE_COMMIT_COMMAND_NAME, performCheckoutAction, true).run();
        } else {
            performCheckoutAction.run();
        }
    }

    private static boolean reformat(VcsConfiguration configuration, boolean checkinProject) {
        return checkinProject ? configuration.REFORMAT_BEFORE_PROJECT_COMMIT : configuration.REFORMAT_BEFORE_FILE_COMMIT;
    }
}

