/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.history.FileHistoryRefresherI;
import com.intellij.openapi.vcs.history.FileHistorySessionPartner;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistoryProviderBackgroundableProxy;
import org.jetbrains.annotations.NotNull;

public class FileHistoryRefresher
implements FileHistoryRefresherI {
    private final FileHistorySessionPartner mySessionPartner;
    private final VcsHistoryProvider myVcsHistoryProvider;
    private final FilePath myPath;
    private final AbstractVcs myVcs;
    private boolean myCanUseCache;
    private boolean myIsRefresh;

    public FileHistoryRefresher(VcsHistoryProvider vcsHistoryProvider, FilePath path, AbstractVcs vcs) {
        this.myVcsHistoryProvider = vcsHistoryProvider;
        this.myPath = path;
        this.myVcs = vcs;
        this.mySessionPartner = new FileHistorySessionPartner(vcsHistoryProvider, path, vcs, this);
        this.myCanUseCache = true;
    }

    @NotNull
    public static FileHistoryRefresherI findOrCreate(@NotNull VcsHistoryProvider vcsHistoryProvider, @NotNull FilePath path, @NotNull AbstractVcs vcs) {
        if (vcsHistoryProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsHistoryProvider", "com/intellij/openapi/vcs/history/FileHistoryRefresher", "findOrCreate"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vcs/history/FileHistoryRefresher", "findOrCreate"));
        }
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/history/FileHistoryRefresher", "findOrCreate"));
        }
        FileHistoryRefresherI refresher = FileHistorySessionPartner.findExistingHistoryRefresher(vcs.getProject(), path);
        FileHistoryRefresherI fileHistoryRefresherI = refresher == null ? new FileHistoryRefresher(vcsHistoryProvider, path, vcs) : refresher;
        if (fileHistoryRefresherI == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/history/FileHistoryRefresher", "findOrCreate"));
        }
        return fileHistoryRefresherI;
    }

    @Override
    public void run(boolean isRefresh, boolean canUseLastRevision) {
        this.myIsRefresh = isRefresh;
        this.mySessionPartner.beforeRefresh();
        VcsHistoryProviderBackgroundableProxy proxy = new VcsHistoryProviderBackgroundableProxy(this.myVcs, this.myVcsHistoryProvider, this.myVcs.getDiffProvider());
        proxy.executeAppendableSession(this.myVcs.getKeyInstanceMethod(), this.myPath, this.mySessionPartner, null, this.myCanUseCache, canUseLastRevision);
        this.myCanUseCache = false;
    }

    @Override
    public boolean isFirstTime() {
        return !this.myIsRefresh;
    }
}

