/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.impl.DefaultVcsRootPolicy;
import com.intellij.openapi.vcs.impl.projectlevelman.NewMappings;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ProjectBaseDirectory;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicDefaultVcsRootPolicy
extends DefaultVcsRootPolicy {
    private final Project myProject;
    private final VirtualFile myBaseDir;

    public BasicDefaultVcsRootPolicy(Project project) {
        this.myProject = project;
        this.myBaseDir = project.getBaseDir();
    }

    @Override
    public void addDefaultVcsRoots(NewMappings mappingList, @NotNull String vcsName, List<VirtualFile> result2) {
        if (vcsName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsName", "com/intellij/openapi/vcs/impl/BasicDefaultVcsRootPolicy", "addDefaultVcsRoots"));
        }
        VirtualFile baseDir = ProjectBaseDirectory.getInstance(this.myProject).getBaseDir(this.myBaseDir);
        if (baseDir != null && vcsName.equals(mappingList.getVcsFor(baseDir))) {
            result2.add(baseDir);
        }
    }

    @Override
    public boolean matchesDefaultMapping(VirtualFile file2, Object matchContext) {
        return VfsUtil.isAncestor((VirtualFile)ProjectBaseDirectory.getInstance(this.myProject).getBaseDir(this.myBaseDir), (VirtualFile)file2, (boolean)false);
    }

    @Override
    @Nullable
    public Object getMatchContext(VirtualFile file2) {
        return null;
    }

    @Override
    @Nullable
    public VirtualFile getVcsRootFor(VirtualFile file2) {
        return ProjectBaseDirectory.getInstance(this.myProject).getBaseDir(this.myBaseDir);
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getDirtyRoots() {
        List<VirtualFile> list = Collections.singletonList(ProjectBaseDirectory.getInstance(this.myProject).getBaseDir(this.myBaseDir));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/BasicDefaultVcsRootPolicy", "getDirtyRoots"));
        }
        return list;
    }
}

