/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.impl.status.TextPanel;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;

public class InlineProgressIndicator
extends ProgressIndicatorBase
implements Disposable {
    private final TextPanel myText;
    private final TextPanel myText2;
    private JProgressBar myProgress;
    private JPanel myComponent;
    private final InplaceButton myCancelButton;
    private final boolean myCompact;
    private TaskInfo myInfo;
    private final TextPanel myProcessName;
    private boolean myDisposed;

    public InlineProgressIndicator(boolean compact, @NotNull TaskInfo processInfo) {
        if (processInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processInfo", "com/intellij/openapi/wm/impl/status/InlineProgressIndicator", "<init>"));
        }
        this.myText = new TextPanel();
        this.myText2 = new TextPanel();
        this.myProcessName = new TextPanel();
        this.myCompact = compact;
        this.myInfo = processInfo;
        this.myCancelButton = new InplaceButton(new IconButton(processInfo.getCancelTooltipText(), AllIcons.Process.Stop, AllIcons.Process.StopHovered){}, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InlineProgressIndicator.this.cancelRequest();
            }
        }).setFillBg(true);
        this.myCancelButton.setVisible(this.myInfo.isCancellable());
        this.myCancelButton.setOpaque(false);
        this.myCancelButton.setToolTipText(processInfo.getCancelTooltipText());
        this.myCancelButton.setFillBg(false);
        this.myProgress = new JProgressBar(0);
        this.myProgress.putClientProperty("JComponent.sizeVariant", "mini");
        this.myComponent = new MyComponent(compact, this.myProcessName);
        if (this.myCompact) {
            this.myComponent.setOpaque(false);
            this.myComponent.setLayout(new BorderLayout(2, 0));
            JPanel textAndProgress = new JPanel(new BorderLayout());
            textAndProgress.setOpaque(false);
            textAndProgress.add((Component)this.myText, "Center");
            NonOpaquePanel progressWrapper = new NonOpaquePanel((LayoutManager)new GridBagLayout());
            progressWrapper.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
            GridBagConstraints c = new GridBagConstraints();
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.insets = new Insets(SystemInfo.isMacOSLion ? 1 : 0, 0, 1, this.myInfo.isCancellable() ? 0 : 4);
            c.fill = 2;
            progressWrapper.add((Component)this.myProgress, (Object)c);
            textAndProgress.add((Component)progressWrapper, "East");
            this.myComponent.add((Component)textAndProgress, "Center");
            this.myComponent.add((Component)this.myCancelButton, "East");
            this.myComponent.setToolTipText(processInfo.getTitle() + ". " + IdeBundle.message((String)"progress.text.clickToViewProgressWindow", (Object[])new Object[0]));
        } else {
            this.myComponent.setLayout(new BorderLayout());
            this.myProcessName.setText(processInfo.getTitle());
            this.myComponent.add((Component)this.myProcessName, "North");
            this.myProcessName.setForeground(UIUtil.getPanelBackground().brighter().brighter());
            this.myProcessName.setBorder(new EmptyBorder(2, 2, 2, 2));
            NonOpaquePanel content = new NonOpaquePanel((LayoutManager)new BorderLayout());
            content.setBorder((Border)new EmptyBorder(2, 2, 2, this.myInfo.isCancellable() ? 2 : 4));
            this.myComponent.add((Component)content, "Center");
            Wrapper cancelWrapper = new Wrapper((JComponent)this.myCancelButton);
            cancelWrapper.setOpaque(false);
            cancelWrapper.setBorder((Border)new EmptyBorder(0, 3, 0, 2));
            content.add((Component)cancelWrapper, (Object)"East");
            content.add((Component)this.myText, (Object)"North");
            content.add((Component)this.myProgress, (Object)"Center");
            content.add((Component)this.myText2, (Object)"South");
            this.myComponent.setBorder(new EmptyBorder(2, 2, 2, 2));
        }
        if (!this.myCompact) {
            this.myProcessName.recomputeSize();
            this.myText.recomputeSize();
            this.myText2.recomputeSize();
        }
    }

    protected void cancelRequest() {
        this.cancel();
    }

    protected void updateProgress() {
        this.queueProgressUpdate();
    }

    protected void updateAndRepaint() {
        if (this.isDisposed()) {
            return;
        }
        this.updateProgressNow();
        this.myComponent.repaint();
    }

    public void updateProgressNow() {
        boolean isStopping;
        boolean indeterminate;
        boolean bl = indeterminate = this.isIndeterminate() || this.getFraction() == 0.0;
        if (indeterminate) {
            this.myProgress.setIndeterminate(true);
        } else {
            this.myProgress.setIndeterminate(false);
            this.myProgress.setMinimum(0);
            this.myProgress.setMaximum(100);
        }
        if (this.getFraction() > 0.0) {
            this.myProgress.setValue((int)(this.getFraction() * 99.0 + 1.0));
        }
        this.myText.setText(this.getText() != null ? this.getText() : "");
        this.myText2.setText(this.getText2() != null ? this.getText2() : "");
        if (this.myCompact && this.myText.getText().length() == 0) {
            this.myText.setText(this.myInfo.getTitle());
        }
        this.myCancelButton.setPainting(this.isCancelable());
        boolean bl2 = isStopping = this.wasStarted() && (this.isCanceled() || !this.isRunning()) && !this.isFinished();
        if (isStopping) {
            if (this.myCompact) {
                this.myText.setText("Stopping - " + this.myText.getText());
            } else {
                this.myProcessName.setText("Stopping - " + this.myInfo.getTitle());
            }
            this.myText.setEnabled(false);
            this.myText2.setEnabled(false);
            this.myProgress.setEnabled(false);
            this.myCancelButton.setPainting(false);
        } else {
            this.myText.setEnabled(true);
            this.myText2.setEnabled(true);
            this.myProgress.setEnabled(true);
            this.myCancelButton.setPainting(true);
        }
    }

    protected boolean isFinished() {
        return false;
    }

    protected void queueProgressUpdate() {
        this.updateAndRepaint();
    }

    protected void queueRunningUpdate(Runnable update) {
        update.run();
    }

    @Override
    protected void onProgressChange() {
        this.updateProgress();
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    public boolean isCompact() {
        return this.myCompact;
    }

    public TaskInfo getInfo() {
        return this.myInfo;
    }

    public void dispose() {
        if (this.myDisposed) {
            return;
        }
        this.myDisposed = true;
        this.myComponent.removeAll();
        this.myComponent = null;
        if (this.myProgress != null) {
            UIUtil.disposeProgress((JProgressBar)this.myProgress);
        }
        this.myProgress = null;
        this.myInfo = null;
    }

    private boolean isDisposed() {
        return this.myDisposed;
    }

    private class MyComponent
    extends JPanel {
        private final boolean myCompact;
        private final JComponent myProcessName;

        private MyComponent(boolean compact, JComponent processName) {
            this.myCompact = compact;
            this.myProcessName = processName;
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (UIUtil.isCloseClick((MouseEvent)e) && MyComponent.this.getBounds().contains(e.getX(), e.getY())) {
                        InlineProgressIndicator.this.cancelRequest();
                    }
                }
            });
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (this.myCompact) {
                super.paintComponent(g);
                return;
            }
            GraphicsConfig c = GraphicsUtil.setupAAPainting((Graphics)g);
            UISettings.setupAntialiasing((Graphics)g);
            int arc = 8;
            Color bg = this.getBackground();
            Rectangle bounds = this.myProcessName.getBounds();
            Rectangle label = SwingUtilities.convertRectangle(this.myProcessName.getParent(), bounds, this);
            g.setColor(UIUtil.getPanelBackground());
            g.fillRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, arc, arc);
            if (!UIUtil.isUnderDarcula()) {
                bg = ColorUtil.toAlpha((Color)bg.darker().darker(), (int)230);
                g.setColor(bg);
                g.fillRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, arc, arc);
                g.setColor(UIUtil.getPanelBackground());
                g.fillRoundRect(0, this.getHeight() / 2, this.getWidth() - 1, this.getHeight() / 2, arc, arc);
                g.fillRect(0, (int)label.getMaxY() + 1, this.getWidth() - 1, this.getHeight() / 2);
            } else {
                bg = bg.brighter();
                g.setColor(bg);
                g.drawLine(0, (int)label.getMaxY() + 1, this.getWidth() - 1, (int)label.getMaxY() + 1);
            }
            g.setColor(bg);
            g.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, arc, arc);
            c.restore();
        }
    }
}

