/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.HectorComponent;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.icons.AllIcons;
import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedWidget;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.UIBundle;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Consumer;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TogglePopupHintsPanel
extends EditorBasedWidget
implements StatusBarWidget.Multiframe,
StatusBarWidget.IconPresentation {
    private Icon myCurrentIcon;
    private String myToolTipText;

    public TogglePopupHintsPanel(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/wm/impl/status/TogglePopupHintsPanel", "<init>"));
        }
        super(project);
        this.myCurrentIcon = AllIcons.Ide.HectorNo;
        this.myConnection.subscribe(PowerSaveMode.TOPIC, (Object)new PowerSaveMode.Listener(){

            @Override
            public void powerSaveStateChanged() {
                TogglePopupHintsPanel.this.updateStatus();
            }
        });
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/wm/impl/status/TogglePopupHintsPanel", "selectionChanged"));
        }
        this.updateStatus();
    }

    public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/openapi/wm/impl/status/TogglePopupHintsPanel", "fileOpened"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/wm/impl/status/TogglePopupHintsPanel", "fileOpened"));
        }
        this.updateStatus();
    }

    public StatusBarWidget copy() {
        return new TogglePopupHintsPanel(this.getProject());
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = this.myCurrentIcon;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/status/TogglePopupHintsPanel", "getIcon"));
        }
        return icon;
    }

    public String getTooltipText() {
        return this.myToolTipText;
    }

    public Consumer<MouseEvent> getClickConsumer() {
        return new Consumer<MouseEvent>(){

            public void consume(MouseEvent e) {
                Point point = new Point(0, 0);
                PsiFile file2 = TogglePopupHintsPanel.this.getCurrentFile();
                if (file2 != null) {
                    if (!DaemonCodeAnalyzer.getInstance((Project)file2.getProject()).isHighlightingAvailable(file2)) {
                        return;
                    }
                    HectorComponent component = new HectorComponent(file2);
                    Dimension dimension = component.getPreferredSize();
                    point = new Point(point.x - dimension.width, point.y - dimension.height);
                    component.showComponent(new RelativePoint(e.getComponent(), point));
                }
            }
        };
    }

    @NotNull
    public String ID() {
        if ("InspectionProfile" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/status/TogglePopupHintsPanel", "ID"));
        }
        return "InspectionProfile";
    }

    public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/wm/impl/status/TogglePopupHintsPanel", "getPresentation"));
        }
        return this;
    }

    public void clear() {
        this.myCurrentIcon = AllIcons.Ide.HectorNo;
        this.myToolTipText = null;
        this.myStatusBar.updateWidget(this.ID());
    }

    public void updateStatus() {
        this.updateStatus(this.getCurrentFile());
    }

    private void updateStatus(PsiFile file2) {
        if (TogglePopupHintsPanel.isStateChangeable(file2)) {
            if (PowerSaveMode.isEnabled()) {
                this.myCurrentIcon = AllIcons.Ide.HectorNo;
                this.myToolTipText = "Code analysis is disabled in power save mode.\n";
            } else if (HighlightingLevelManager.getInstance(this.myProject).shouldInspect((PsiElement)file2)) {
                this.myCurrentIcon = AllIcons.Ide.HectorOn;
                this.myToolTipText = "Current inspection profile: " + InspectionProjectProfileManager.getInstance(file2.getProject()).getInspectionProfile().getName() + ".\n";
            } else if (HighlightingLevelManager.getInstance(this.myProject).shouldHighlight((PsiElement)file2)) {
                this.myCurrentIcon = AllIcons.Ide.HectorSyntax;
                this.myToolTipText = "Highlighting level is: Syntax.\n";
            } else {
                this.myCurrentIcon = AllIcons.Ide.HectorOff;
                this.myToolTipText = "Inspections are off.\n";
            }
            this.myToolTipText = this.myToolTipText + UIBundle.message((String)"popup.hints.panel.click.to.configure.highlighting.tooltip.text", (Object[])new Object[0]);
        } else {
            this.myCurrentIcon = AllIcons.Ide.HectorNo;
            this.myToolTipText = null;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && this.myStatusBar != null) {
            this.myStatusBar.updateWidget(this.ID());
        }
    }

    private static boolean isStateChangeable(PsiFile file2) {
        return file2 != null && DaemonCodeAnalyzer.getInstance((Project)file2.getProject()).isHighlightingAvailable(file2);
    }

    @Nullable
    private PsiFile getCurrentFile() {
        VirtualFile virtualFile = this.getSelectedFile();
        if (virtualFile != null && virtualFile.isValid()) {
            return PsiManager.getInstance((Project)this.getProject()).findFile(virtualFile);
        }
        return null;
    }
}

