/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.compiler;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.util.containers.MultiMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.api.CmdlineRemoteProto;
import org.jetbrains.jps.incremental.artifacts.ArtifactBuildTargetType;

public class ArtifactCompilerUtil {
    private ArtifactCompilerUtil() {
    }

    public static boolean containsArtifacts(List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> scopes) {
        for (CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope scope : scopes) {
            if (!ArtifactBuildTargetType.INSTANCE.getTypeId().equals(scope.getTypeId())) continue;
            return true;
        }
        return false;
    }

    public static MultiMap<String, Artifact> createOutputToArtifactMap(final Project project) {
        final MultiMap result2 = MultiMap.create((TObjectHashingStrategy)FileUtil.PATH_HASHING_STRATEGY);
        new ReadAction(){

            protected void run(@NotNull Result r) {
                if (r == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/packaging/impl/compiler/ArtifactCompilerUtil$1", "run"));
                }
                for (Artifact artifact : ArtifactManager.getInstance((Project)project).getArtifacts()) {
                    String outputPath = artifact.getOutputFilePath();
                    if (StringUtil.isEmpty((String)outputPath)) continue;
                    result2.putValue((Object)outputPath, (Object)artifact);
                }
            }
        }.execute();
        return result2;
    }
}

