/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.xml;

import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import java.util.HashMap;
import java.util.Map;

public class HtmlPolicy
extends XmlFormattingPolicy {
    protected final CodeStyleSettings mySettings;
    private final Map<String, String[]> myCachedSplits = new HashMap<String, String[]>();

    public HtmlPolicy(CodeStyleSettings settings, FormattingDocumentModel documentModel) {
        super(documentModel);
        this.mySettings = settings;
    }

    @Override
    public boolean indentChildrenOf(XmlTag parentTag) {
        if (parentTag == null) {
            return true;
        }
        PsiElement firstChild = this.findFirstNonEmptyChild(parentTag);
        if (firstChild == null) {
            return false;
        }
        if (firstChild.getNode().getElementType() != XmlTokenType.XML_START_TAG_START) {
            return false;
        }
        if (this.mySettings.HTML_DO_NOT_ALIGN_CHILDREN_OF_MIN_LINES > 0 && this.getLines(parentTag) > this.mySettings.HTML_DO_NOT_ALIGN_CHILDREN_OF_MIN_LINES) {
            return false;
        }
        return !this.checkName(parentTag, this.mySettings.HTML_DO_NOT_INDENT_CHILDREN_OF);
    }

    private PsiElement findFirstNonEmptyChild(XmlTag parentTag) {
        PsiElement result2;
        for (result2 = parentTag.getFirstChild(); result2 != null && result2.getTextLength() == 0; result2 = result2.getNextSibling()) {
        }
        return result2;
    }

    private int getLines(XmlTag parentTag) {
        TextRange textRange = parentTag.getTextRange();
        return this.myDocumentModel.getLineNumber(textRange.getEndOffset()) - this.myDocumentModel.getLineNumber(textRange.getStartOffset()) + 1;
    }

    @Override
    public boolean insertLineBreakBeforeTag(XmlTag xmlTag) {
        ASTNode prevNode;
        PsiElement prev = xmlTag.getPrevSibling();
        if (prev == null) {
            return false;
        }
        for (prevNode = SourceTreeToPsiMap.psiElementToTree(prev); prevNode != null && this.containsWhiteSpacesOnly(prevNode); prevNode = prevNode.getTreePrev()) {
        }
        if (prevNode == null) {
            return false;
        }
        if (!(SourceTreeToPsiMap.treeElementToPsi(prevNode) instanceof XmlTag)) {
            return false;
        }
        return this.checkName(xmlTag, this.mySettings.HTML_ELEMENTS_TO_INSERT_NEW_LINE_BEFORE);
    }

    @Override
    public boolean insertLineBreakBeforeFirstAttribute(XmlAttribute attribute) {
        return false;
    }

    @Override
    public boolean insertLineBreakAfterLastAttribute(XmlAttribute attribute) {
        return false;
    }

    @Override
    public boolean insertLineBreakAfterTagBegin(XmlTag tag) {
        return false;
    }

    private boolean containsWhiteSpacesOnly(ASTNode node) {
        if (node == null) {
            return false;
        }
        if (node.getElementType() == TokenType.WHITE_SPACE) {
            return true;
        }
        if (node instanceof LeafElement) {
            return false;
        }
        for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (this.containsWhiteSpacesOnly(child)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeLineBreakBeforeTag(XmlTag xmlTag) {
        return this.checkName(xmlTag, this.mySettings.HTML_ELEMENTS_TO_REMOVE_NEW_LINE_BEFORE);
    }

    protected boolean checkName(XmlTag tag, String option) {
        if (option == null) {
            return false;
        }
        for (String name : this.getTagNames(option)) {
            if (!name.trim().equalsIgnoreCase(tag.getName())) continue;
            return true;
        }
        return false;
    }

    private String[] getTagNames(String option) {
        String[] splits = this.myCachedSplits.get(option);
        if (splits == null) {
            splits = option.split(",");
            this.myCachedSplits.put(option, splits);
        }
        return splits;
    }

    @Override
    public boolean keepWhiteSpacesInsideTag(XmlTag tag) {
        return this.checkName(tag, this.mySettings.HTML_KEEP_WHITESPACES_INSIDE) || "jsp:attribute".equals(tag.getName());
    }

    @Override
    public WrapType getWrappingTypeForTagEnd(XmlTag xmlTag) {
        return this.shouldBeWrapped(xmlTag) ? WrapType.ALWAYS : WrapType.NORMAL;
    }

    @Override
    public WrapType getWrappingTypeForTagBegin(XmlTag tag) {
        if (this.shouldBeWrapped(tag)) {
            return WrapType.ALWAYS;
        }
        if (!this.isInlineTag(tag)) {
            if (this.checkName(tag, this.mySettings.HTML_DONT_ADD_BREAKS_IF_INLINE_CONTENT) && this.hasInlineContentOnly(tag)) {
                return WrapType.NORMAL;
            }
            return WrapType.ALWAYS;
        }
        return WrapType.NORMAL;
    }

    private boolean hasInlineContentOnly(XmlTag tag) {
        XmlTag[] tags;
        for (XmlTag xmlTag : tags = tag.getSubTags()) {
            if (!this.isInlineTag(xmlTag)) {
                return false;
            }
            if (this.hasInlineContentOnly(xmlTag)) continue;
            return false;
        }
        return true;
    }

    protected boolean isInlineTag(XmlTag tag) {
        return this.checkName(tag, this.mySettings.HTML_INLINE_ELEMENTS);
    }

    protected boolean shouldBeWrapped(XmlTag tag) {
        return false;
    }

    @Override
    public boolean isTextElement(XmlTag tag) {
        return this.isInlineTag(tag);
    }

    @Override
    public int getTextWrap(XmlTag tag) {
        return this.mySettings.HTML_TEXT_WRAP;
    }

    @Override
    public int getAttributesWrap() {
        return this.mySettings.HTML_ATTRIBUTE_WRAP;
    }

    @Override
    public boolean getShouldAlignAttributes() {
        return this.mySettings.HTML_ALIGN_ATTRIBUTES;
    }

    @Override
    public boolean getShouldAlignText() {
        return this.mySettings.HTML_ALIGN_TEXT;
    }

    @Override
    public boolean getShouldKeepWhiteSpaces() {
        return this.mySettings.HTML_KEEP_WHITESPACES;
    }

    @Override
    public boolean getShouldAddSpaceAroundEqualityInAttribute() {
        return this.mySettings.HTML_SPACE_AROUND_EQUALITY_IN_ATTRINUTE;
    }

    @Override
    public boolean getShouldAddSpaceAroundTagName() {
        return this.mySettings.HTML_SPACE_AFTER_TAG_NAME;
    }

    @Override
    public int getKeepBlankLines() {
        return this.mySettings.HTML_KEEP_BLANK_LINES;
    }

    @Override
    public boolean getShouldKeepLineBreaks() {
        return this.mySettings.HTML_KEEP_LINE_BREAKS;
    }

    @Override
    public boolean getShouldKeepLineBreaksInText() {
        return this.mySettings.HTML_KEEP_LINE_BREAKS_IN_TEXT;
    }

    @Override
    public boolean getKeepWhiteSpacesInsideCDATA() {
        return true;
    }

    @Override
    public int getWhiteSpaceAroundCDATAOption() {
        return 0;
    }

    @Override
    public CodeStyleSettings getSettings() {
        return this.mySettings;
    }

    @Override
    public boolean addSpaceIntoEmptyTag() {
        return this.mySettings.HTML_SPACE_INSIDE_EMPTY_TAG;
    }

    @Override
    public boolean shouldSaveSpacesBetweenTagAndText() {
        return true;
    }
}

