/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class LightTypeElement
extends LightElement
implements PsiTypeElement {
    private final PsiType myType;

    public LightTypeElement(PsiManager manager, PsiType type) {
        super(manager, (Language)JavaLanguage.INSTANCE);
        this.myType = type = PsiUtil.convertAnonymousToBaseType((PsiType)type);
    }

    @Override
    public String toString() {
        return "PsiTypeElement:" + this.getText();
    }

    @Override
    public String getText() {
        return this.myType.getPresentableText();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/light/LightTypeElement", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitTypeElement((PsiTypeElement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public PsiElement copy() {
        return new LightTypeElement(this.myManager, this.myType);
    }

    @NotNull
    public PsiType getType() {
        PsiType psiType = this.myType;
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightTypeElement", "getType"));
        }
        return psiType;
    }

    public PsiJavaCodeReferenceElement getInnermostComponentReferenceElement() {
        return null;
    }

    @Override
    public boolean isValid() {
        return this.myType.isValid();
    }

    @NotNull
    public PsiAnnotation[] getAnnotations() {
        PsiAnnotation[] psiAnnotationArray = this.myType.getAnnotations();
        if (psiAnnotationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightTypeElement", "getAnnotations"));
        }
        return psiAnnotationArray;
    }

    public PsiAnnotation findAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/impl/light/LightTypeElement", "findAnnotation"));
        }
        return this.myType.findAnnotation(qualifiedName);
    }

    @NotNull
    public PsiAnnotation addAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/impl/light/LightTypeElement", "addAnnotation"));
        }
        throw new IncorrectOperationException();
    }

    @NotNull
    public PsiAnnotation[] getApplicableAnnotations() {
        PsiAnnotation[] psiAnnotationArray = this.getAnnotations();
        if (psiAnnotationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightTypeElement", "getApplicableAnnotations"));
        }
        return psiAnnotationArray;
    }
}

