/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod;

import com.intellij.codeInsight.JavaPsiEquivalenceUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffManager;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.SimpleContent;
import com.intellij.openapi.diff.SimpleDiffRequest;
import com.intellij.openapi.diff.ex.DiffPanelEx;
import com.intellij.openapi.diff.ex.DiffPanelOptions;
import com.intellij.openapi.diff.impl.ComparisonPolicy;
import com.intellij.openapi.diff.impl.processing.HighlightMode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.extractMethod.InputVariables;
import com.intellij.refactoring.extractMethod.ParametersFolder;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.VariableData;
import com.intellij.refactoring.util.duplicates.DuplicatesFinder;
import com.intellij.refactoring.util.duplicates.Match;
import com.intellij.refactoring.util.duplicates.MethodDuplicatesHandler;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.text.UniqueNameGenerator;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class ExtractMethodSignatureSuggester {
    private static final Logger LOG = Logger.getInstance((String)("#" + ExtractMethodSignatureSuggester.class.getName()));
    private static final TObjectHashingStrategy<PsiExpression> ourEquivalenceStrategy = new TObjectHashingStrategy<PsiExpression>(){

        public int computeHashCode(PsiExpression object) {
            return RefactoringUtil.unparenthesizeExpression(object).getClass().hashCode();
        }

        public boolean equals(PsiExpression o1, PsiExpression o2) {
            return JavaPsiEquivalenceUtil.areExpressionsEquivalent(RefactoringUtil.unparenthesizeExpression(o1), RefactoringUtil.unparenthesizeExpression(o2));
        }
    };
    private final Project myProject;
    private final PsiElementFactory myElementFactory;
    private PsiMethod myExtractedMethod;
    private PsiMethodCallExpression myMethodCall;
    private VariableData[] myVariableData;

    public ExtractMethodSignatureSuggester(Project project, PsiMethod extractedMethod, PsiMethodCallExpression methodCall, VariableData[] variableDatum) {
        this.myProject = project;
        this.myElementFactory = JavaPsiFacade.getElementFactory((Project)project);
        PsiClass containingClass = extractedMethod.getContainingClass();
        LOG.assertTrue(containingClass != null);
        this.myExtractedMethod = this.myElementFactory.createMethodFromText(extractedMethod.getText(), containingClass.getLBrace());
        this.myMethodCall = methodCall;
        this.myVariableData = variableDatum;
    }

    public List<Match> getDuplicates(final PsiMethod method, final PsiMethodCallExpression methodCall, ParametersFolder folder) {
        List<Match> duplicates = this.findDuplicatesSignature(method, folder);
        if (duplicates != null && !duplicates.isEmpty() && (ApplicationManager.getApplication().isUnitTestMode() || new PreviewDialog(method, this.myExtractedMethod, methodCall, this.myMethodCall, duplicates.size()).showAndGet())) {
            PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
            WriteCommandAction.runWriteCommandAction((Project)this.myProject, (Runnable)new Runnable(){

                @Override
                public void run() {
                    ExtractMethodSignatureSuggester.this.myMethodCall = (PsiMethodCallExpression)methodCall.replace((PsiElement)ExtractMethodSignatureSuggester.this.myMethodCall);
                    ExtractMethodSignatureSuggester.this.myExtractedMethod = (PsiMethod)method.replace((PsiElement)ExtractMethodSignatureSuggester.this.myExtractedMethod);
                }
            });
            DuplicatesFinder finder = MethodDuplicatesHandler.createDuplicatesFinder((PsiMember)this.myExtractedMethod);
            if (finder != null) {
                List<VariableData> datas = finder.getParameters().getInputVariables();
                this.myVariableData = datas.toArray(new VariableData[datas.size()]);
                return finder.findDuplicates((PsiElement)this.myExtractedMethod.getContainingClass());
            }
        }
        return null;
    }

    public PsiMethod getExtractedMethod() {
        return this.myExtractedMethod;
    }

    public PsiMethodCallExpression getMethodCall() {
        return this.myMethodCall;
    }

    public VariableData[] getVariableData() {
        return this.myVariableData;
    }

    @Nullable
    public List<Match> findDuplicatesSignature(final PsiMethod method, ParametersFolder folder) {
        ArrayList<PsiExpression> copies = new ArrayList<PsiExpression>();
        InputVariables variables = this.detectTopLevelExpressionsToReplaceWithParameters(copies);
        if (variables == null) {
            return null;
        }
        DuplicatesFinder defaultFinder = MethodDuplicatesHandler.createDuplicatesFinder((PsiMember)this.myExtractedMethod);
        if (defaultFinder == null) {
            return null;
        }
        DuplicatesFinder finder = new DuplicatesFinder(defaultFinder.getPattern(), variables, defaultFinder.getReturnValue(), new ArrayList()){

            @Override
            protected boolean isSelf(PsiElement candidate) {
                return PsiTreeUtil.isAncestor((PsiElement)method, (PsiElement)candidate, (boolean)true);
            }
        };
        List<Match> duplicates = finder.findDuplicates((PsiElement)method.getContainingClass());
        if (duplicates != null && !duplicates.isEmpty()) {
            this.restoreRenamedParams(copies, folder);
            if (!this.myMethodCall.isValid()) {
                return null;
            }
            this.myMethodCall = (PsiMethodCallExpression)this.myMethodCall.copy();
            this.inlineSameArguments(method, copies, variables, duplicates);
            for (PsiExpression expression : copies) {
                this.myMethodCall.getArgumentList().add((PsiElement)expression);
            }
            return duplicates;
        }
        return null;
    }

    private void inlineSameArguments(PsiMethod method, List<PsiExpression> copies, InputVariables variables, List<Match> duplicates) {
        int strongParamsCound;
        List<VariableData> variableDatum = variables.getInputVariables();
        HashMap<PsiVariable, PsiExpression> toInline = new HashMap<PsiVariable, PsiExpression>();
        for (int i = strongParamsCound = method.getParameterList().getParametersCount(); i < variableDatum.size(); ++i) {
            THashSet map;
            VariableData variableData = variableDatum.get(i);
            if (!ExtractMethodSignatureSuggester.collectParamValues(duplicates, variableData, (THashSet<PsiExpression>)(map = new THashSet(ourEquivalenceStrategy)))) continue;
            PsiExpression currentExpression = copies.get(i - strongParamsCound);
            map.add((Object)currentExpression);
            if (map.size() != 1) continue;
            toInline.put(variableData.variable, currentExpression);
        }
        if (!toInline.isEmpty()) {
            copies.removeAll(toInline.values());
            this.inlineArgumentsInMethodBody(toInline);
            this.removeRedundantParametersFromMethodSignature(toInline);
        }
        this.removeUnusedStongParams(strongParamsCound);
    }

    private void removeUnusedStongParams(int strongParamsCound) {
        PsiExpression[] expressions = this.myMethodCall.getArgumentList().getExpressions();
        PsiParameter[] parameters = this.myExtractedMethod.getParameterList().getParameters();
        PsiCodeBlock body = this.myExtractedMethod.getBody();
        if (body != null) {
            LocalSearchScope scope = new LocalSearchScope((PsiElement)body);
            for (int i = strongParamsCound - 1; i >= 0; --i) {
                PsiParameter parameter = parameters[i];
                if (ReferencesSearch.search((PsiElement)parameter, (SearchScope)scope).findFirst() != null) continue;
                parameter.delete();
                expressions[i].delete();
            }
        }
    }

    private void removeRedundantParametersFromMethodSignature(Map<PsiVariable, PsiExpression> param2ExprMap) {
        for (PsiParameter parameter : this.myExtractedMethod.getParameterList().getParameters()) {
            if (!param2ExprMap.containsKey(parameter)) continue;
            parameter.delete();
        }
    }

    private void inlineArgumentsInMethodBody(final Map<PsiVariable, PsiExpression> param2ExprMap) {
        final HashMap replacement = new HashMap();
        this.myExtractedMethod.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                PsiExpression toInlineExpr;
                super.visitReferenceExpression(expression);
                PsiElement resolve = expression.resolve();
                if (resolve instanceof PsiVariable && (toInlineExpr = (PsiExpression)param2ExprMap.get((PsiVariable)resolve)) != null) {
                    replacement.put(expression, toInlineExpr);
                }
            }
        });
        for (PsiExpression expression : replacement.keySet()) {
            expression.replace((PsiElement)replacement.get(expression));
        }
    }

    private static boolean collectParamValues(List<Match> duplicates, VariableData variableData, THashSet<PsiExpression> map) {
        for (Match duplicate : duplicates) {
            List<PsiElement> values = duplicate.getParameterValues(variableData.variable);
            if (values == null || values.isEmpty()) {
                return false;
            }
            boolean found = false;
            for (PsiElement value : values) {
                if (!(value instanceof PsiExpression)) continue;
                map.add((Object)((PsiExpression)value));
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private void restoreRenamedParams(List<PsiExpression> copies, ParametersFolder folder) {
        final HashMap<String, String> renameMap = new HashMap<String, String>();
        for (VariableData data : this.myVariableData) {
            String replacement = folder.getGeneratedCallArgument(data);
            if (data.name.equals(replacement)) continue;
            renameMap.put(data.name, replacement);
        }
        if (!renameMap.isEmpty()) {
            for (PsiExpression currentExpression : copies) {
                final HashMap params = new HashMap();
                currentExpression.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                    public void visitReferenceExpression(PsiReferenceExpression expression) {
                        super.visitReferenceExpression(expression);
                        PsiElement resolve = expression.resolve();
                        if (resolve instanceof PsiParameter && ExtractMethodSignatureSuggester.this.myExtractedMethod.equals(((PsiParameter)resolve).getDeclarationScope())) {
                            String name = ((PsiParameter)resolve).getName();
                            String variable = (String)renameMap.get(name);
                            if (renameMap.containsKey(name)) {
                                params.put(expression, variable);
                            }
                        }
                    }
                });
                for (PsiReferenceExpression expression : params.keySet()) {
                    String var = (String)params.get(expression);
                    expression.replace((PsiElement)this.myElementFactory.createExpressionFromText(var, (PsiElement)expression));
                }
            }
        }
    }

    @Nullable
    private InputVariables detectTopLevelExpressionsToReplaceWithParameters(List<PsiExpression> copies) {
        PsiParameter[] parameters = this.myExtractedMethod.getParameterList().getParameters();
        ArrayList<PsiParameter> inputVariables = new ArrayList<PsiParameter>(Arrays.asList(parameters));
        PsiCodeBlock body = this.myExtractedMethod.getBody();
        LOG.assertTrue(body != null);
        PsiStatement[] pattern = body.getStatements();
        final ArrayList exprs = new ArrayList();
        for (PsiStatement statement : pattern) {
            PsiExpression expression;
            if (statement instanceof PsiExpressionStatement && ((expression = ((PsiExpressionStatement)statement).getExpression()) instanceof PsiIfStatement || expression instanceof PsiLoopStatement)) continue;
            statement.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitCallExpression(PsiCallExpression callExpression) {
                    PsiExpressionList list = callExpression.getArgumentList();
                    if (list != null) {
                        for (PsiExpression expression : list.getExpressions()) {
                            if (expression instanceof PsiReferenceExpression) {
                                PsiElement resolve = ((PsiReferenceExpression)expression).resolve();
                                if (!(resolve instanceof PsiField)) continue;
                                exprs.add(expression);
                                continue;
                            }
                            exprs.add(expression);
                        }
                    }
                }
            });
        }
        if (exprs.isEmpty()) {
            return null;
        }
        UniqueNameGenerator uniqueNameGenerator = new UniqueNameGenerator();
        for (PsiParameter parameter : parameters) {
            uniqueNameGenerator.addExistingName(parameter.getName());
        }
        THashMap unique = new THashMap(ourEquivalenceStrategy);
        HashMap<PsiExpression, String> replacement = new HashMap<PsiExpression, String>();
        for (PsiExpression expr : exprs) {
            String name = (String)unique.get((Object)expr);
            if (name == null) {
                PsiType type = GenericsUtil.getVariableTypeByExpressionType((PsiType)expr.getType());
                if (type == null || type == PsiType.NULL || PsiUtil.resolveClassInType((PsiType)type) instanceof PsiAnonymousClass) {
                    return null;
                }
                copies.add(this.myElementFactory.createExpressionFromText(expr.getText(), (PsiElement)body));
                SuggestedNameInfo info = JavaCodeStyleManager.getInstance((Project)this.myProject).suggestVariableName(VariableKind.PARAMETER, null, expr, null);
                String paramName = info.names.length > 0 ? info.names[0] : "p";
                name = uniqueNameGenerator.generateUniqueName(paramName);
                PsiParameter parameter = (PsiParameter)this.myExtractedMethod.getParameterList().add((PsiElement)this.myElementFactory.createParameter(name, type));
                inputVariables.add(parameter);
                unique.put((Object)expr, (Object)name);
            }
            replacement.put(expr, name);
        }
        for (PsiExpression expression : replacement.keySet()) {
            expression.replace((PsiElement)this.myElementFactory.createExpressionFromText((String)replacement.get(expression), null));
        }
        return new InputVariables(inputVariables, this.myExtractedMethod.getProject(), new LocalSearchScope((PsiElement)this.myExtractedMethod), false);
    }

    private static class PreviewDialog
    extends DialogWrapper {
        private final PsiMethod myOldMethod;
        private final PsiMethod myNewMethod;
        private final PsiMethodCallExpression myOldCall;
        private final PsiMethodCallExpression myNewCall;
        private final int myDuplicatesNumber;

        public PreviewDialog(PsiMethod oldMethod, PsiMethod newMethod, PsiMethodCallExpression oldMethodCall, PsiMethodCallExpression newMethodCall, int duplicatesNumber) {
            super(oldMethod.getProject());
            this.myOldMethod = oldMethod;
            this.myNewMethod = newMethod;
            this.myOldCall = oldMethodCall;
            this.myNewCall = newMethodCall;
            this.myDuplicatesNumber = duplicatesNumber;
            this.setTitle("Extract Parameters to Replace Duplicates");
            this.setOKButtonText("Accept Signature Change");
            this.setCancelButtonText("Keep Original Signature");
            this.init();
        }

        @Nullable
        protected JComponent createNorthPanel() {
            return new JLabel("<html><b>No exact method duplicates were found</b>, though changed method as shown below has " + this.myDuplicatesNumber + " duplicate" + (this.myDuplicatesNumber > 1 ? "s" : "") + " </html>");
        }

        @Nullable
        protected JComponent createCenterPanel() {
            Project project = this.myOldMethod.getProject();
            DiffPanelEx diffPanel = (DiffPanelEx)DiffManager.getInstance().createDiffPanel(null, project, this.getDisposable(), null);
            diffPanel.setComparisonPolicy(ComparisonPolicy.IGNORE_SPACE);
            diffPanel.setHighlightMode(HighlightMode.BY_WORD);
            DiffPanelOptions diffPanelOptions = diffPanel.getOptions();
            diffPanelOptions.setShowSourcePolicy(DiffPanelOptions.ShowSourcePolicy.OPEN_EDITOR);
            diffPanelOptions.setRequestFocusOnNewContent(false);
            SimpleDiffRequest request = new SimpleDiffRequest(project, null);
            String oldContent = this.myOldMethod.getText() + "\n\n\nmethod call:\n " + this.myOldCall.getText();
            String newContent = this.myNewMethod.getText() + "\n\n\nmethod call:\n " + this.myNewCall.getText();
            request.setContents((DiffContent)new SimpleContent(oldContent), (DiffContent)new SimpleContent(newContent));
            request.setContentTitles("Before", "After");
            diffPanel.setDiffRequest((DiffRequest)request);
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)diffPanel.getComponent(), "Center");
            panel.setBorder(IdeBorderFactory.createEmptyBorder((Insets)new Insets(5, 0, 0, 0)));
            return panel;
        }
    }
}

