/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceField;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.unwrap.ScopeHighlighter;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduceVariable.IntroduceVariableBase;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.Iterator;
import java.util.List;

public class ElementToWorkOn {
    public static final Key<PsiElement> PARENT = Key.create((String)"PARENT");
    private final PsiExpression myExpression;
    private final PsiLocalVariable myLocalVariable;
    public static final Key<String> PREFIX = Key.create((String)"prefix");
    public static final Key<String> SUFFIX = Key.create((String)"suffix");
    public static final Key<RangeMarker> TEXT_RANGE = Key.create((String)"range");
    public static final Key<Boolean> REPLACE_NON_PHYSICAL = Key.create((String)"replace_non_physical");
    public static final Key<Boolean> OUT_OF_CODE_BLOCK = Key.create((String)"out_of_code_block");

    private ElementToWorkOn(PsiLocalVariable localVariable, PsiExpression expr) {
        this.myLocalVariable = localVariable;
        this.myExpression = expr;
    }

    public PsiExpression getExpression() {
        return this.myExpression;
    }

    public PsiLocalVariable getLocalVariable() {
        return this.myLocalVariable;
    }

    public boolean isInvokedOnDeclaration() {
        return this.myExpression == null;
    }

    public static void processElementToWorkOn(final Editor editor, final PsiFile file2, final String refactoringName, final String helpId, final Project project, final ElementsProcessor<ElementToWorkOn> processor2) {
        PsiLocalVariable localVar = null;
        PsiExpression expr = null;
        if (!editor.getSelectionModel().hasSelection()) {
            PsiElement element = TargetElementUtil.findTargetElement(editor, 11);
            if (element instanceof PsiLocalVariable) {
                localVar = (PsiLocalVariable)element;
                PsiElement elementAt = file2.findElementAt(editor.getCaretModel().getOffset());
                if (elementAt instanceof PsiIdentifier && elementAt.getParent() instanceof PsiReferenceExpression) {
                    expr = (PsiExpression)elementAt.getParent();
                } else {
                    PsiElement refElement;
                    PsiReference reference = TargetElementUtil.findReference(editor);
                    if (reference != null && (refElement = reference.getElement()) instanceof PsiReferenceExpression) {
                        expr = (PsiReferenceExpression)refElement;
                    }
                }
            } else {
                final PsiLocalVariable variable = (PsiLocalVariable)PsiTreeUtil.getParentOfType((PsiElement)file2.findElementAt(editor.getCaretModel().getOffset()), PsiLocalVariable.class);
                int offset = editor.getCaretModel().getOffset();
                PsiElement[] statementsInRange = IntroduceVariableBase.findStatementsAtOffset(editor, file2, offset);
                if (statementsInRange.length == 1 && IntroduceVariableBase.selectLineAtCaret(offset, statementsInRange)) {
                    editor.getSelectionModel().selectLineAtCaret();
                    ElementToWorkOn elementToWorkOn = ElementToWorkOn.getElementToWorkOn(editor, file2, refactoringName, helpId, project, localVar, expr);
                    if (elementToWorkOn == null || elementToWorkOn.getLocalVariable() == null && elementToWorkOn.getExpression() == null || !processor2.accept(elementToWorkOn)) {
                        editor.getSelectionModel().removeSelection();
                    }
                }
                if (!editor.getSelectionModel().hasSelection()) {
                    List<PsiExpression> expressions = IntroduceVariableBase.collectExpressions(file2, editor, offset);
                    Iterator<PsiExpression> iterator = expressions.iterator();
                    while (iterator.hasNext()) {
                        PsiExpression expression = iterator.next();
                        if (processor2.accept(new ElementToWorkOn(null, expression))) continue;
                        iterator.remove();
                    }
                    if (expressions.isEmpty()) {
                        editor.getSelectionModel().selectLineAtCaret();
                    } else if (!IntroduceVariableBase.isChooserNeeded(expressions)) {
                        expr = expressions.get(0);
                    } else {
                        int selection = IntroduceVariableBase.preferredSelection(statementsInRange, expressions);
                        IntroduceTargetChooser.showChooser(editor, expressions, new Pass<PsiExpression>(){

                            public void pass(PsiExpression selectedValue) {
                                PsiLocalVariable var = null;
                                if (variable != null && variable.getInitializer() == selectedValue) {
                                    var = variable;
                                }
                                processor2.pass(ElementToWorkOn.getElementToWorkOn(editor, file2, refactoringName, helpId, project, var, selectedValue));
                            }
                        }, new PsiExpressionTrimRenderer.RenderFunction(), "Expressions", selection, ScopeHighlighter.NATURAL_RANGER);
                        return;
                    }
                }
            }
        }
        processor2.pass(ElementToWorkOn.getElementToWorkOn(editor, file2, refactoringName, helpId, project, localVar, expr));
    }

    private static ElementToWorkOn getElementToWorkOn(Editor editor, PsiFile file2, String refactoringName, String helpId, Project project, PsiLocalVariable localVar, PsiExpression expr) {
        String errorMessage;
        PsiIdentifier ident;
        int startOffset = 0;
        int endOffset = 0;
        if (localVar == null && expr == null && (expr = CodeInsightUtil.findExpressionInRange(file2, startOffset = editor.getSelectionModel().getSelectionStart(), endOffset = editor.getSelectionModel().getSelectionEnd())) == null && (ident = CodeInsightUtil.findElementInRange(file2, startOffset, endOffset, PsiIdentifier.class)) != null) {
            localVar = (PsiLocalVariable)PsiTreeUtil.getParentOfType((PsiElement)ident, PsiLocalVariable.class);
        }
        if (expr == null && localVar == null) {
            PsiDeclarationStatement decl;
            PsiElement[] declaredElements;
            PsiElement[] statements = CodeInsightUtil.findStatementsInRange(file2, startOffset, endOffset);
            if (statements.length == 1 && statements[0] instanceof PsiExpressionStatement) {
                expr = ((PsiExpressionStatement)statements[0]).getExpression();
            } else if (statements.length == 1 && statements[0] instanceof PsiDeclarationStatement && (declaredElements = (decl = (PsiDeclarationStatement)statements[0]).getDeclaredElements()).length == 1 && declaredElements[0] instanceof PsiLocalVariable) {
                localVar = (PsiLocalVariable)declaredElements[0];
            }
        }
        if (localVar == null && expr == null) {
            expr = IntroduceVariableBase.getSelectedExpression(project, file2, startOffset, endOffset);
        }
        if (localVar == null && expr != null && (errorMessage = IntroduceVariableBase.getErrorMessage(expr)) != null) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)errorMessage, (String)refactoringName, (String)helpId);
            return null;
        }
        return new ElementToWorkOn(localVar, expr);
    }

    public static void showNothingSelectedErrorMessage(Editor editor, String refactoringName, String helpId, Project project) {
        String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.local.or.expression.name"));
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)refactoringName, (String)helpId);
    }

    public static interface ElementsProcessor<T> {
        public boolean accept(ElementToWorkOn var1);

        public void pass(T var1);
    }
}

