/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.openapi.util.text.StringUtil;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class DockerCredentialsHolder {
    public static final String DOCKER_MACHINE_NAME = "DOCKER_MACHINE_NAME";
    public static final String DOCKER_IMAGE_NAME = "DOCKER_IMAGE_NAME";
    public static final String DOCKER_CONTAINER_NAME = "DOCKER_CONTAINER_NAME";
    public static final String DOCKER_REMOTE_PROJECT_PATH = "DOCKER_REMOTE_PROJECT_PATH";
    private String myMachineName;
    private String myImageName;
    private String myContainerName;
    private String myRemoteProjectPath;

    public DockerCredentialsHolder() {
    }

    public DockerCredentialsHolder(String machineName, String imageName, String containerName, String remoteProjectPath) {
        this.myMachineName = machineName;
        this.myImageName = imageName;
        this.myContainerName = containerName;
        this.myRemoteProjectPath = remoteProjectPath;
    }

    public String getMachineName() {
        return this.myMachineName;
    }

    public String getImageName() {
        return this.myImageName;
    }

    public String getContainerName() {
        return this.myContainerName;
    }

    public String getRemoteProjectPath() {
        return this.myRemoteProjectPath;
    }

    public void save(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/remote/DockerCredentialsHolder", "save"));
        }
        if (StringUtil.isNotEmpty((String)this.myMachineName)) {
            element.setAttribute(DOCKER_MACHINE_NAME, this.myMachineName);
        }
        element.setAttribute(DOCKER_IMAGE_NAME, this.myImageName);
        if (StringUtil.isNotEmpty((String)this.myContainerName)) {
            element.setAttribute(DOCKER_CONTAINER_NAME, this.myContainerName);
        }
        element.setAttribute(DOCKER_REMOTE_PROJECT_PATH, this.myRemoteProjectPath);
    }

    public void load(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/remote/DockerCredentialsHolder", "load"));
        }
        this.myMachineName = element.getAttributeValue(DOCKER_MACHINE_NAME);
        this.myImageName = element.getAttributeValue(DOCKER_IMAGE_NAME);
        this.myContainerName = element.getAttributeValue(DOCKER_CONTAINER_NAME);
        this.myRemoteProjectPath = element.getAttributeValue(DOCKER_REMOTE_PROJECT_PATH);
    }
}

