/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.configuration.deployment;

import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configuration.ConfigurationFactoryEx;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.RunDialog;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfigurationManager;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerConfigurationType;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerConfigurationTypesRegistrar;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfiguration;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeploymentConfigurationManagerImpl
extends DeploymentConfigurationManager {
    private final Project myProject;

    public DeploymentConfigurationManagerImpl(Project project) {
        this.myProject = project;
    }

    @NotNull
    public List<RunnerAndConfigurationSettings> getDeploymentConfigurations(@NotNull ServerType<?> serverType) {
        if (serverType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverType", "com/intellij/remoteServer/impl/configuration/deployment/DeploymentConfigurationManagerImpl", "getDeploymentConfigurations"));
        }
        DeployToServerConfigurationType configurationType = DeployToServerConfigurationTypesRegistrar.getDeployConfigurationType(serverType);
        List list = RunManager.getInstance((Project)this.myProject).getConfigurationSettingsList((ConfigurationType)configurationType);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/configuration/deployment/DeploymentConfigurationManagerImpl", "getDeploymentConfigurations"));
        }
        return list;
    }

    public void createAndRunConfiguration(@NotNull ServerType<?> serverType, @Nullable RemoteServer<?> remoteServer) {
        if (serverType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverType", "com/intellij/remoteServer/impl/configuration/deployment/DeploymentConfigurationManagerImpl", "createAndRunConfiguration"));
        }
        DeployToServerConfigurationType configurationType = DeployToServerConfigurationTypesRegistrar.getDeployConfigurationType(serverType);
        RunManagerEx runManager = RunManagerEx.getInstanceEx(this.myProject);
        ConfigurationFactoryEx factory = configurationType.getFactory();
        RunnerAndConfigurationSettings settings = runManager.createRunConfiguration(configurationType.getDisplayName(), factory);
        factory.onNewConfigurationCreated(settings.getConfiguration());
        DeployToServerRunConfiguration runConfiguration = (DeployToServerRunConfiguration)settings.getConfiguration();
        if (remoteServer != null) {
            runConfiguration.setServerName(remoteServer.getName());
        }
        if (RunDialog.editConfiguration(this.myProject, settings, "Create Deployment Configuration", DefaultRunExecutor.getRunExecutorInstance())) {
            runManager.addConfiguration(settings, runManager.isConfigurationShared(settings), runManager.getBeforeRunTasks((RunConfiguration)runConfiguration), false);
            runManager.setSelectedConfiguration(settings);
            ProgramRunnerUtil.executeConfiguration(this.myProject, settings, DefaultRunExecutor.getRunExecutorInstance());
        }
    }
}

